/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.awc.rest;

import com.jetbrains.bundle.awc.exceptions.AdminConsoleException;
import com.jetbrains.bundle.awc.exceptions.ObjectNotFoundException;
import com.jetbrains.bundle.awc.model.ExternalHubInfo;
import com.jetbrains.bundle.awc.model.request.SwitchExternalHubRequest;
import com.jetbrains.bundle.awc.model.request.ValidateHubUrlRequest;
import com.jetbrains.bundle.awc.service.HubManagerService;
import com.jetbrains.bundle.hub_client.util.validation.AdditionalKeystore;
import com.jetbrains.bundle.hub_client.util.validation.CertificateInfo;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/hub/external"}, produces={"application/json"})
public class HubExternalController {
    @Autowired
    HubManagerService myHubManagerService;
    @Autowired
    AdditionalKeystore additionalKeystore;

    @RequestMapping(method={RequestMethod.GET}, value={"/validate"})
    public ExternalHubInfo validateGet(@RequestParam(value="awcToken") String awcToken, @RequestParam(value="url", required=true) String url, @RequestParam(value="confirmed", required=false) Boolean confirmedNotUsingHomeUrl, @RequestParam(value="fields", required=false) String fields) throws AdminConsoleException {
        return this.myHubManagerService.validate(url, Boolean.TRUE.equals(confirmedNotUsingHomeUrl));
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/validate"})
    public ExternalHubInfo validatePost(@RequestParam(value="awcToken") String awcToken, @RequestBody ValidateHubUrlRequest request, @RequestParam(value="fields", required=false) String fields) throws AdminConsoleException {
        return this.myHubManagerService.validate(request.getUrl(), Boolean.TRUE.equals(request.getConfirmedNotUsingHomeUrl()));
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/switch"})
    public void switchToHub(@RequestBody SwitchExternalHubRequest request, @RequestParam(value="awcToken") String awcToken, @RequestParam(value="fields", required=false) String fields) throws AdminConsoleException {
        this.myHubManagerService.switchToHub(request.getUrl(), Boolean.TRUE.equals(request.getConfirmed()));
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/certificates/"})
    @ResponseBody
    public CertificateInfo[] getCertificates() {
        return this.additionalKeystore.getCertificates();
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/certificates/{fingerprint}"})
    @ResponseBody
    public CertificateInfo getCertificate(HttpServletRequest request, @PathVariable(value="fingerprint") String fingerprint) throws ObjectNotFoundException {
        CertificateInfo info = this.additionalKeystore.getCertificate(fingerprint);
        if (info == null) {
            throw new ObjectNotFoundException("Certificate", fingerprint);
        }
        return info;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/certificates/"})
    @ResponseBody
    public CertificateInfo addCertificate(@RequestBody CertificateInfo info) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        this.additionalKeystore.setCertificate(info.getFingerprintSHA1(), info);
        return info;
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/certificates/{fingerprint}"})
    @ResponseBody
    public void deleteCertificate(@PathVariable(value="fingerprint") String fingerprint) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        this.additionalKeystore.removeCertificate(fingerprint);
    }
}

