/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.awc.rest;

import com.jetbrains.bundle.awc.exceptions.AdminConsoleException;
import com.jetbrains.bundle.awc.exceptions.ErrorMessage;
import com.jetbrains.bundle.awc.exceptions.MigrationStatusException;
import com.jetbrains.bundle.awc.model.MigrationInfo;
import com.jetbrains.bundle.awc.model.MigrationStatusInfo;
import com.jetbrains.bundle.awc.model.request.PrepareMigrationRequest;
import com.jetbrains.bundle.awc.model.request.StartMigrationRequest;
import com.jetbrains.bundle.awc.service.HubManagerService;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/hub/migration"}, produces={"application/json"})
public class HubMigrationController {
    @Autowired
    HubManagerService myHubManagerService;

    @RequestMapping(method={RequestMethod.GET})
    public MigrationInfo getMigration(@RequestParam(value="awcToken") String awcToken, @RequestParam(value="fields", required=false) String fields) throws AdminConsoleException {
        return this.myHubManagerService.getMigrationInfo(awcToken);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/status"})
    public MigrationStatusInfo getMigrationStatus(@RequestParam(value="awcToken", required=true) String awcToken, @RequestParam(value="externalHubToken", required=false) String externalHubToken, @RequestParam(value="fields", required=false) String fields) throws AdminConsoleException {
        MigrationStatusInfo result = this.myHubManagerService.getMigrationStatus(externalHubToken);
        if (result.getStatus() != null && (result.getStatus().equals("failed") || result.getStatus().endsWith("-failed"))) {
            throw new MigrationStatusException(result);
        }
        return result;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/finish"})
    public MigrationInfo finishMigration(@RequestParam(value="awcToken") String awcToken, @RequestParam(value="externalHubToken", required=false) String externalHubToken, @RequestParam(value="fields", required=false) String fields) throws AdminConsoleException {
        this.myHubManagerService.finishMigration(externalHubToken);
        return null;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/start"})
    public MigrationInfo startMigration(@RequestBody StartMigrationRequest requestBody, @RequestParam(value="awcToken") String awcToken, @RequestParam(value="externalHubToken", required=false) String externalHubToken, @RequestParam(value="fields", required=false) String fields, HttpServletRequest request) throws AdminConsoleException {
        String referrerUrl = request.getHeader("Referer");
        this.myHubManagerService.startMigration(externalHubToken, referrerUrl, Boolean.TRUE.equals(requestBody.getConfirmed()));
        return null;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/prepare"})
    public MigrationInfo prepareMigration(@RequestBody PrepareMigrationRequest request, @RequestParam(value="awcToken") String awcToken, @RequestParam(value="fields", required=false) String fields) throws AdminConsoleException {
        if (request.getExternalHubUrl() == null) {
            throw new AdminConsoleException(ErrorMessage.PARAMETER_MISSING, "externalHubUrl");
        }
        return this.myHubManagerService.prepareMigration(request.getExternalHubUrl(), request.getRedirectUri(), request.getUserLogin(), request.getUserPassword(), request.getRelinkAfterImportFlag() == null ? Boolean.TRUE : request.getRelinkAfterImportFlag());
    }

    @RequestMapping(method={RequestMethod.DELETE})
    public void deleteMigration(@RequestParam(value="awcToken", required=true) String awcToken, @RequestParam(value="externalHubToken", required=false) String externalHubToken, @RequestParam(value="fields", required=false) String fields) throws AdminConsoleException {
        this.myHubManagerService.deleteMigration(externalHubToken);
    }
}

