/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.awc.rest;

import com.jetbrains.bundle.api.internal.awc.ext.AdminConsoleExtension;
import com.jetbrains.bundle.api.internal.awc.ext.model.ProductState;
import com.jetbrains.bundle.awc.exceptions.AdminConsoleException;
import com.jetbrains.bundle.awc.model.ProductStateInfo;
import com.jetbrains.bundle.util.BundleUtil;
import javax.servlet.http.HttpServletRequest;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/product/state"}, produces={"application/json"})
public class ProductStateController {
    @Autowired
    AdminConsoleExtension myAdminConsoleExtension;

    @RequestMapping(method={RequestMethod.GET})
    public ProductStateInfo getMigrationStatus(@RequestParam(value="fields", required=false) String fields, HttpServletRequest request) throws AdminConsoleException {
        return this.convert(this.myAdminConsoleExtension.getProductState(), request);
    }

    @Nullable
    private ProductStateInfo convert(@Nullable ProductState productState, HttpServletRequest request) {
        if (productState == null) {
            return null;
        }
        return new ProductStateInfo(productState.isStarting(), productState.getProductName(), productState.getProductPresentationName(), BundleUtil.resolveServiceUrlForClient((HttpServletRequest)request, (String)productState.getDefaultServiceUrl()), productState.getRunId(), productState.getProxyHelpLink());
    }
}

