/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.awc.rest;

import com.intellij.hub.auth.oauth2.consumer.OAuth2TokenLoadException;
import com.intellij.hub.core.Error;
import com.jetbrains.bundle.awc.exceptions.AdminConsoleException;
import com.jetbrains.bundle.awc.exceptions.AlreadyInUseException;
import com.jetbrains.bundle.awc.exceptions.ErrorMessage;
import com.jetbrains.bundle.awc.exceptions.ExternalHubValidationException;
import com.jetbrains.bundle.awc.exceptions.ExternalHubWrappedException;
import com.jetbrains.bundle.awc.exceptions.HubHomeUrlUnavailableException;
import com.jetbrains.bundle.awc.exceptions.ImportForbiddenException;
import com.jetbrains.bundle.awc.exceptions.MigrationStatusException;
import com.jetbrains.bundle.awc.exceptions.ObjectNotFoundException;
import com.jetbrains.bundle.awc.model.error.AuthErrorResult;
import com.jetbrains.bundle.awc.model.error.ErrorResult;
import com.jetbrains.bundle.awc.model.error.ExternalHubAuthErrorResult;
import com.jetbrains.bundle.awc.model.error.ExternalHubUrlValidationFailureResult;
import com.jetbrains.bundle.awc.model.error.FailedStatusResult;
import com.jetbrains.bundle.awc.model.error.HubHomeUrlUnavailableResult;
import com.jetbrains.bundle.awc.model.error.TooManyFailedAuthAttemptsResult;
import com.jetbrains.bundle.util.auth.exceptions.AuthenticationException;
import com.jetbrains.bundle.util.auth.exceptions.TooManyFailedAuthAttemptsException;
import java.net.URI;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.WebApplicationException;
import jetbrains.jetpass.client.resource.ErrorHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
public class RequestErrorHandler {
    protected Logger LOG = LoggerFactory.getLogger(this.getClass());

    @ResponseStatus(value=HttpStatus.CONFLICT)
    @ExceptionHandler(value={AlreadyInUseException.class})
    @ResponseBody
    public ErrorResult handleException(AlreadyInUseException exception) {
        this.logExceptionCausedByAnotherException(exception);
        return new ErrorResult(exception.getCode(), exception.getMessage());
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={ObjectNotFoundException.class})
    @ResponseBody
    public ErrorResult handleException(ObjectNotFoundException exception) {
        this.logExceptionCausedByAnotherException(exception);
        return new ErrorResult(exception.getCode(), exception.getMessage());
    }

    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ExceptionHandler(value={AuthenticationException.class})
    @ResponseBody
    public ErrorResult handleException(AuthenticationException exception) {
        this.logExceptionCausedByAnotherException((Exception)exception);
        ErrorMessage errorMessage = ErrorMessage.ADMIN_CONSOLE_AUTH_EXCEPTION;
        return new AuthErrorResult(errorMessage.getCode(), errorMessage.getMessage(new String[0]), exception.getTokenStorage().toString());
    }

    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ExceptionHandler(value={TooManyFailedAuthAttemptsException.class})
    @ResponseBody
    public ErrorResult handleException(TooManyFailedAuthAttemptsException exception) {
        this.logExceptionCausedByAnotherException((Exception)exception);
        ErrorMessage errorMessage = ErrorMessage.TOO_MANY_FAILED_AUTHENTICATION_ATTEMPTS;
        return new TooManyFailedAuthAttemptsResult(errorMessage.getCode(), errorMessage.getMessage(new String[0]), exception.getIntervalToWaitInMillis(), exception.getFailedAttemptsCount(), exception.getTokenStorage().toString());
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={MigrationStatusException.class})
    @ResponseBody
    public ErrorResult handleException(MigrationStatusException exception) {
        this.logExceptionCausedByAnotherException(exception);
        return new FailedStatusResult(exception.getCode(), exception.getMessage(), exception.getMigrationStatusInfo());
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={ExternalHubValidationException.class})
    @ResponseBody
    public ExternalHubUrlValidationFailureResult handleException(ExternalHubValidationException e) {
        this.logExceptionCausedByAnotherException(e);
        return new ExternalHubUrlValidationFailureResult(e.getCode(), e.getMessage(), e.getValidationResult());
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={HubHomeUrlUnavailableException.class})
    @ResponseBody
    public HubHomeUrlUnavailableResult handleException(HubHomeUrlUnavailableException e) {
        this.logExceptionCausedByAnotherException(e);
        return new HubHomeUrlUnavailableResult(e.getCode(), e.getMessage(), e.getHubHomeUrl());
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={ForbiddenException.class})
    @ResponseBody
    public ErrorResult handleException(ForbiddenException exception) {
        this.logException((Exception)((Object)exception));
        ErrorMessage errorMessage = ErrorMessage.EXTERNAL_HUB_AUTHORIZATION_BY_TOKEN_FAILED;
        return new ErrorResult(errorMessage.getCode(), errorMessage.getMessage(new String[0]));
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={NotAuthorizedException.class})
    @ResponseBody
    public ErrorResult handleException(NotAuthorizedException exception) {
        this.logException((Exception)exception);
        ErrorMessage errorMessage = ErrorMessage.EXTERNAL_HUB_AUTHORIZATION_BY_TOKEN_FAILED;
        return new ErrorResult(errorMessage.getCode(), errorMessage.getMessage(new String[0]));
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={ExternalHubWrappedException.class})
    @ResponseBody
    public ErrorResult handleException(ExternalHubWrappedException exception) {
        this.logExceptionCausedByAnotherException(exception);
        Error error = exception.getCause() instanceof WebApplicationException ? ErrorHelper.INSTANCE.readError((WebApplicationException)exception.getCause()) : null;
        return new ErrorResult(exception.getCode(), exception.getMessage(), error);
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={ImportForbiddenException.class})
    @ResponseBody
    public ErrorResult handleException(ImportForbiddenException exception) {
        this.logExceptionCausedByAnotherException(exception);
        Error error = exception.getError();
        return new ErrorResult(exception.getCode(), exception.getMessage(), error);
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={OAuth2TokenLoadException.class})
    @ResponseBody
    public ErrorResult handleException(final OAuth2TokenLoadException exception) {
        this.logException((Exception)exception);
        ErrorMessage errorMessage = ErrorMessage.EXTERNAL_HUB_AUTHORIZATION_BY_SERVICE_FAILED;
        return new ExternalHubAuthErrorResult(errorMessage.getCode(), errorMessage.getMessage(new String[0]), new Error(){

            @NotNull
            public String getError() {
                return exception.getError();
            }

            public int getStatusCode() {
                return exception.getStatusCode();
            }

            @NotNull
            public String getMessage() {
                return exception.getMessage();
            }

            @Nullable
            public String getDeveloperMessage() {
                return exception.getDeveloperMessage();
            }

            @Nullable
            public URI getURI() {
                return exception.getURI();
            }

            @Nullable
            public String getField() {
                return exception.getField();
            }
        });
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={AdminConsoleException.class})
    @ResponseBody
    public ErrorResult handleException(AdminConsoleException exception) {
        this.logExceptionCausedByAnotherException(exception);
        return new ErrorResult(exception.getCode(), exception.getMessage());
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={RuntimeException.class})
    @ResponseBody
    public ErrorResult handleException(RuntimeException e) {
        this.logException(e);
        return new ErrorResult(ErrorMessage.UNEXPECTED.getCode(), ErrorMessage.UNEXPECTED.getMessage(e.getMessage()));
    }

    private void logException(Exception e) {
        this.LOG.debug(e.getMessage() != null ? e.getMessage() : "", (Throwable)e);
    }

    private void logExceptionCausedByAnotherException(Exception e) {
        if (e.getCause() != null) {
            this.logException(e);
        }
    }
}

