/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.awc.service.impl;

import com.jetbrains.bundle.api.internal.awc.ext.model.HubSettings;
import com.jetbrains.bundle.api.internal.awc.ext.model.migration.MigrationInterface;
import com.jetbrains.bundle.awc.exceptions.AdminConsoleException;
import com.jetbrains.bundle.awc.model.ExternalHubInfo;
import com.jetbrains.bundle.awc.model.HubInfo;
import com.jetbrains.bundle.awc.model.MigrationInfo;
import com.jetbrains.bundle.awc.model.MigrationStatusInfo;
import com.jetbrains.bundle.awc.service.HubManagerService;
import com.jetbrains.bundle.awc.service.MigrationServicesProvider;
import com.jetbrains.bundle.awc.service.impl.actions.DeleteMigrationAction;
import com.jetbrains.bundle.awc.service.impl.actions.FinishMigrationAction;
import com.jetbrains.bundle.awc.service.impl.actions.GetMigrationAction;
import com.jetbrains.bundle.awc.service.impl.actions.GetStatusAction;
import com.jetbrains.bundle.awc.service.impl.actions.PrepareMigrationAction;
import com.jetbrains.bundle.awc.service.impl.actions.StartMigrationAction;
import com.jetbrains.bundle.awc.service.impl.actions.SwitchExternalHubAction;
import com.jetbrains.bundle.awc.service.impl.actions.ValidateBeforeSwitchExternalHubAction;
import java.net.URLDecoder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HubManagerServiceImp
implements HubManagerService {
    @NotNull
    final MigrationServicesProvider myMigrationServicesProvider;
    private Logger LOG = LoggerFactory.getLogger(this.getClass());

    public HubManagerServiceImp(@NotNull MigrationServicesProvider migrationServicesProvider) {
        this.myMigrationServicesProvider = migrationServicesProvider;
    }

    @Override
    public MigrationInfo getMigrationInfo(@NotNull String awcToken) throws AdminConsoleException {
        GetMigrationAction getMigrationAction = new GetMigrationAction(this.myMigrationServicesProvider);
        MigrationInterface migration = this.myMigrationServicesProvider.getHubActionExecutor().execute(getMigrationAction);
        return this.convert(migration);
    }

    @Override
    @Nullable
    public MigrationInfo prepareMigration(@NotNull String hubUrl, String redirectUriForExternalHubService, String userLogin, String userPassword, boolean relinkAfterImport) throws AdminConsoleException {
        PrepareMigrationAction prepareMigrationAction = new PrepareMigrationAction(hubUrl, redirectUriForExternalHubService, userLogin, userPassword, this.myMigrationServicesProvider, relinkAfterImport);
        MigrationInterface migration = this.myMigrationServicesProvider.getHubActionExecutor().execute(prepareMigrationAction);
        return this.convert(migration);
    }

    @Override
    public void startMigration(@Nullable String externalHubToken, @NotNull String referrerUrl, boolean confirmed) throws AdminConsoleException {
        StartMigrationAction startMigrationAction = new StartMigrationAction(externalHubToken, referrerUrl, confirmed, this.myMigrationServicesProvider);
        this.myMigrationServicesProvider.getHubActionExecutor().execute(startMigrationAction);
    }

    @Override
    public MigrationStatusInfo getMigrationStatus(@Nullable String externalHubToken) throws AdminConsoleException {
        GetStatusAction getStatusAction = new GetStatusAction(externalHubToken, this.myMigrationServicesProvider);
        return this.myMigrationServicesProvider.getHubActionExecutor().execute(getStatusAction);
    }

    @Override
    public void finishMigration(@Nullable String externalHubToken) throws AdminConsoleException {
        FinishMigrationAction finishMigrationAction = new FinishMigrationAction(externalHubToken, this.myMigrationServicesProvider);
        this.myMigrationServicesProvider.getHubActionExecutor().execute(finishMigrationAction);
    }

    @Override
    public void deleteMigration(@Nullable String externalHubToken) throws AdminConsoleException {
        DeleteMigrationAction deleteMigrationAction = new DeleteMigrationAction(externalHubToken, this.myMigrationServicesProvider);
        this.myMigrationServicesProvider.getHubActionExecutor().execute(deleteMigrationAction);
    }

    @Override
    public HubInfo getHubInfo() {
        return this.convert(this.myMigrationServicesProvider.getAdminConsoleExtension().getHubSettings());
    }

    @Override
    public ExternalHubInfo validate(@NotNull String url, boolean confirmedNotUsingHomeUrl) throws AdminConsoleException {
        ValidateBeforeSwitchExternalHubAction validateBeforeSwitchExternalHubAction = new ValidateBeforeSwitchExternalHubAction(url, this.myMigrationServicesProvider, confirmedNotUsingHomeUrl);
        return this.myMigrationServicesProvider.getHubActionExecutor().execute(validateBeforeSwitchExternalHubAction);
    }

    @Override
    public void switchToHub(@Nullable String url, boolean confirmedNotUsingHomeUrl) throws AdminConsoleException {
        SwitchExternalHubAction switchExternalHubAction = new SwitchExternalHubAction(url, this.myMigrationServicesProvider, confirmedNotUsingHomeUrl);
        this.myMigrationServicesProvider.getHubActionExecutor().execute(switchExternalHubAction);
    }

    @Nullable
    private MigrationInfo convert(@Nullable MigrationInterface migration) {
        if (migration == null) {
            return null;
        }
        MigrationInfo result = new MigrationInfo();
        result.setHubUrl(migration.getExternalHubUrl());
        result.setHubHomeUrl(migration.getExternalHubHomeUrl());
        result.setHubHomeUrlIsAvailable(migration.isExternalHubHubHomeUrlAvailable());
        result.setServiceId(migration.getExternalHubServiceId());
        result.setIsServiceVerified(migration.isServiceVerified());
        result.setIsActive(migration.isActive());
        result.setExternalHubMigrationId(migration.getExternalHubMigrationId());
        result.setIsRelinkAfterImport(migration.isRelinkAfterImport());
        return result;
    }

    @Nullable
    private HubInfo convert(@NotNull HubSettings hubSettings) {
        return new HubInfo(hubSettings.getUrl(), hubSettings.getServiceId(), hubSettings.isInternal(), hubSettings.isRunning(), hubSettings.isInternalHubExists(), hubSettings.isRelinkToExternalHubAllowed());
    }

    public static void main(String[] args) {
        System.out.println(URLDecoder.decode("1431363640388.3d7bf17a-1500-4b30-8846-f930cf9e7af2.b1fa04c6-a975-4799-8138-94551dab310a.0-0-0-0-0%3B1.MCwCFG1%2FsbMAHxUyjD4ugCkDHqOUIwkiAhRJB1hh%2FvyVwFAJhp0zF3Qy5Sw%2BDQ%3D%3D"));
    }
}

