/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.awc.service.impl.actions;

import com.jetbrains.bundle.api.internal.awc.ext.model.HubSettings;
import com.jetbrains.bundle.awc.exceptions.AdminConsoleException;
import com.jetbrains.bundle.awc.exceptions.ErrorMessage;
import com.jetbrains.bundle.awc.service.MigrationServicesProvider;
import com.jetbrains.bundle.awc.service.impl.actions.HubMigrationAction;
import com.jetbrains.bundle.hub_client.util.validation.HubUrlValidator;
import com.jetbrains.bundle.hub_client.util.validation.ValidationResult;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CheckServicesInExternalHubAction
extends HubMigrationAction<Map<String, String>> {
    @NotNull
    private final String myExternalHubUrl;
    @NotNull
    private final HubUrlValidator myHubUrlValidator;

    public CheckServicesInExternalHubAction(@NotNull String url, @NotNull MigrationServicesProvider migrationServicesProvider) {
        super(migrationServicesProvider);
        this.myExternalHubUrl = url;
        this.myHubUrlValidator = migrationServicesProvider.getHubUrlValidator();
    }

    @Override
    boolean isReadOnly() {
        return true;
    }

    @Override
    Map<String, String> execute() throws AdminConsoleException {
        return this.checkProductServicesAreRegisteredInHub(this.myExternalHubUrl);
    }

    private Map<String, String> checkProductServicesAreRegisteredInHub(String hubUrl) throws AdminConsoleException {
        HubSettings hubSettings = this.getAdminConsoleExtension().getHubSettings();
        Map servicesInHubWithSecrets = hubSettings.getHubServicesWithSecrets();
        ValidationResult result = new ValidationResult();
        this.myHubUrlValidator.checkServicesAreRegisteredInHub(hubUrl, servicesInHubWithSecrets, result, "hubUrl");
        if (result.hasErrors()) {
            throw new AdminConsoleException(ErrorMessage.TARGET_HUB_DOES_NOT_HAVE_SERVICES_REGISTERED_BY_PRODUCT, result.getErrors()[0].getDescription());
        }
        return servicesInHubWithSecrets;
    }
}

