/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.awc.service.impl.actions;

import com.jetbrains.bundle.api.internal.awc.ext.model.migration.MigrationInterface;
import com.jetbrains.bundle.awc.exceptions.AdminConsoleException;
import com.jetbrains.bundle.awc.service.MigrationServicesProvider;
import com.jetbrains.bundle.awc.service.impl.actions.HubMigrationAction;
import jetbrains.jetpass.client.accounts.ImportClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeleteMigrationAction
extends HubMigrationAction<Void> {
    @Nullable
    private final String myExternalHubToken;

    public DeleteMigrationAction(@Nullable String externalHubToken, @NotNull MigrationServicesProvider migrationServicesProvider) {
        super(migrationServicesProvider);
        this.myExternalHubToken = externalHubToken;
    }

    @Override
    boolean isReadOnly() {
        return false;
    }

    @Override
    Void execute() throws AdminConsoleException {
        MigrationInterface migration = this.getMigration();
        try {
            if (migration != null) {
                this.setInternalHubReadOnlyMode(false);
                if (migration.getExternalHubMigrationId() != null) {
                    ImportClient importClient = this.getImportClient(this.myExternalHubToken);
                    importClient.deleteImport(migration.getExternalHubMigrationId());
                }
                this.removeServiceFromExternalHub(this.myExternalHubToken);
            }
        }
        finally {
            this.clearMigrationState();
        }
        return null;
    }
}

