/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.awc.service.impl.actions;

import com.jetbrains.bundle.api.internal.awc.ext.AdminConsoleExtension;
import com.jetbrains.bundle.api.internal.awc.ext.model.migration.MigrationInterface;
import com.jetbrains.bundle.api.internal.awc.ext.model.migration.MigrationStatusEnum;
import com.jetbrains.bundle.awc.exceptions.AdminConsoleException;
import com.jetbrains.bundle.awc.model.MigrationStatusInfo;
import com.jetbrains.bundle.awc.service.MigrationServicesProvider;
import com.jetbrains.bundle.awc.service.impl.actions.HubMigrationAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FinishMigrationAction
extends HubMigrationAction<Void> {
    @Nullable
    private final String myExternalHubToken;
    @NotNull
    private final AdminConsoleExtension myAdminConsoleExtension;

    public FinishMigrationAction(@Nullable String externalHubToken, @NotNull MigrationServicesProvider migrationServicesProvider) {
        super(migrationServicesProvider);
        this.myExternalHubToken = externalHubToken;
        this.myAdminConsoleExtension = migrationServicesProvider.getAdminConsoleExtension();
    }

    @Override
    boolean isReadOnly() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Void execute() throws AdminConsoleException {
        this.assertExternalHubToken(this.myExternalHubToken);
        MigrationInterface migration = this.getMigration();
        if (migration == null || migration.getExternalHubMigrationId() == null) {
            throw new AdminConsoleException("finishMigration could not be called earlier than import of DB to External Hub successfully performed");
        }
        MigrationStatusInfo migrationStatusInfo = this.getMigrationStatusInfo(this.myExternalHubToken);
        if (!MigrationStatusEnum.IMPORT_DONE.getValue().equalsIgnoreCase(migrationStatusInfo.getStatus())) {
            throw new AdminConsoleException(String.format("finishMigration could be called for migration in status '%s' only", MigrationStatusEnum.IMPORT_DONE.getValue()));
        }
        try {
            try {
                this.setInternalHubReadOnlyMode(false);
            }
            catch (Exception e) {
                this.LOG.warn("Failed to switch off read only mode of internal Hub", (Throwable)e);
            }
            this.removeServiceFromExternalHub(this.myExternalHubToken);
            if (migration.isRelinkAfterImport()) {
                this.relinkToExternalHub(migration);
            }
        }
        finally {
            this.clearMigrationState();
        }
        return null;
    }

    private void relinkToExternalHub(MigrationInterface migration) throws AdminConsoleException {
        try {
            this.setMigrationStatus(MigrationStatusEnum.APPLY_EXTERNAL_HUB);
            this.myAdminConsoleExtension.applyExternalHub(migration.getExternalHubUrl());
            this.setMigrationStatus(MigrationStatusEnum.APPLIED);
        }
        catch (Throwable e) {
            this.setMigrationStatus(MigrationStatusEnum.APPLY_EXTERNAL_HUB_FAILED);
            throw e;
        }
    }
}

