/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.awc.service.impl.actions;

import com.jetbrains.bundle.api.internal.awc.ext.model.migration.MigrationInterface;
import com.jetbrains.bundle.api.internal.awc.ext.model.migration.MigrationStatusEnum;
import com.jetbrains.bundle.api.internal.awc.ext.model.migration.MigrationStatusInterface;
import com.jetbrains.bundle.awc.exceptions.AdminConsoleException;
import com.jetbrains.bundle.awc.exceptions.ObjectNotFoundException;
import com.jetbrains.bundle.awc.model.MigrationStatusInfo;
import com.jetbrains.bundle.awc.service.MigrationServicesProvider;
import com.jetbrains.bundle.awc.service.impl.actions.HubMigrationAction;
import jetbrains.jetpass.client.BaseField;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.accounts.ImportClient;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.hub2hub.dto.ImportJSON;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GetStatusAction
extends HubMigrationAction<MigrationStatusInfo> {
    @Nullable
    private final String myExternalHubToken;

    public GetStatusAction(@Nullable String externalHubToken, @NotNull MigrationServicesProvider migrationServicesProvider) {
        super(migrationServicesProvider);
        this.myExternalHubToken = externalHubToken;
    }

    @Override
    boolean isReadOnly() {
        return true;
    }

    @Override
    MigrationStatusInfo execute() throws AdminConsoleException {
        this.assertExternalHubToken(this.myExternalHubToken);
        MigrationInterface migration = this.getMigration();
        if (migration.getExternalHubMigrationId() != null && (migration.getStatus() == null || MigrationStatusEnum.IMPORT_DONE.isGreaterThan(migration.getStatus().getStatus()))) {
            ImportClient importClient = this.getImportClient(this.myExternalHubToken);
            ImportJSON importJSON = importClient.getImport(migration.getExternalHubMigrationId(), new FieldPartial((BaseField[])new Partial.Import[]{Partial.Import.PHASE((Partial.ImportPhase[])new Partial.ImportPhase[]{Partial.ImportPhase.NAME, Partial.ImportPhase.PROGRESS, Partial.ImportPhase.MESSAGE})}));
            if (importJSON == null) {
                throw new ObjectNotFoundException("Migration in External Hub", migration.getExternalHubMigrationId());
            }
            if (importJSON.getPhase() == null) {
                throw new AdminConsoleException(String.format("Migration with id %s exists in Hub [%s], but its status is not resolved", migration.getExternalHubMigrationId(), migration.getExternalHubUrl()));
            }
            MigrationStatusInfo migrationStatus = new MigrationStatusInfo();
            migrationStatus.setProgress(importJSON.getPhase().getProgress());
            migrationStatus.setMessage(importJSON.getPhase().getMessage());
            migrationStatus.setStatus(importJSON.getPhase().getName());
            return migrationStatus;
        }
        if (migration.getStatus() == null) {
            throw new ObjectNotFoundException("Migration status", null);
        }
        return this.convert(migration.getStatus());
    }

    @Nullable
    private MigrationStatusInfo convert(@Nullable MigrationStatusInterface migrationStatus) {
        if (migrationStatus == null) {
            return null;
        }
        MigrationStatusInfo result = new MigrationStatusInfo();
        result.setStatus(migrationStatus.getStatus().getValue());
        result.setProgress(migrationStatus.getProgress());
        result.setMessage(migrationStatus.getMessage());
        return result;
    }
}

