/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.awc.service.impl.actions;

import com.jetbrains.bundle.awc.exceptions.AdminConsoleException;
import com.jetbrains.bundle.awc.exceptions.AlreadyInUseException;
import com.jetbrains.bundle.awc.service.impl.actions.HubMigrationAction;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;

public class HubActionExecutor {
    private final ReentrantLock executionLock = new ReentrantLock();

    public final <T> T execute(@NotNull HubMigrationAction<T> action) throws AdminConsoleException {
        if (action.isReadOnly()) {
            return action.execute();
        }
        if (this.executionLock.tryLock()) {
            try {
                T t = action.execute();
                return t;
            }
            finally {
                this.executionLock.unlock();
            }
        }
        throw new AlreadyInUseException(action.getClass().getSimpleName());
    }
}

