/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.awc.service.impl.actions;

import com.intellij.hub.auth.AuthToken;
import com.intellij.hub.auth.oauth2.consumer.OneTimeTokenHolder;
import com.intellij.hub.auth.oauth2.consumer.TokenHolder;
import com.intellij.hub.auth.oauth2.token.AccessToken;
import com.jetbrains.bundle.api.internal.awc.ext.AdminConsoleExtension;
import com.jetbrains.bundle.api.internal.awc.ext.model.HubSettings;
import com.jetbrains.bundle.api.internal.awc.ext.model.migration.Migration;
import com.jetbrains.bundle.api.internal.awc.ext.model.migration.MigrationInterface;
import com.jetbrains.bundle.api.internal.awc.ext.model.migration.MigrationStatusEnum;
import com.jetbrains.bundle.awc.exceptions.AdminConsoleException;
import com.jetbrains.bundle.awc.exceptions.ErrorMessage;
import com.jetbrains.bundle.awc.exceptions.ExternalHubNotAllowedMigrationException;
import com.jetbrains.bundle.awc.exceptions.ExternalHubValidationException;
import com.jetbrains.bundle.awc.exceptions.ObjectNotFoundException;
import com.jetbrains.bundle.awc.model.ExternalHubInfo;
import com.jetbrains.bundle.awc.model.MigrationStatusInfo;
import com.jetbrains.bundle.awc.service.MigrationServicesProvider;
import com.jetbrains.bundle.awc.service.impl.actions.GetStatusAction;
import com.jetbrains.bundle.awc.service.impl.actions.HubMigrationHolder;
import com.jetbrains.bundle.hub_client.util.BundleHubClient;
import com.jetbrains.bundle.hub_client.util.HubClientProvider;
import com.jetbrains.bundle.hub_client.util.HubUtil;
import com.jetbrains.bundle.hub_client.util.validation.HubHomeUrlInfo;
import com.jetbrains.bundle.hub_client.util.validation.HubUrlValidator;
import com.jetbrains.bundle.hub_client.util.validation.IServiceClientFactory;
import com.jetbrains.bundle.hub_client.util.validation.ValidationResult;
import jetbrains.jetpass.client.accounts.BaseAccountsClient;
import jetbrains.jetpass.client.accounts.ImportClient;
import jetbrains.jetpass.client.accounts.ServiceClient;
import jetbrains.jetpass.client.hub.HubClient;
import jetbrains.jetpass.rest.dto.BackupSettingsJSON;
import jetbrains.jetpass.rest.dto.SettingsJSON;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HubMigrationAction<T> {
    public static final String BACKUP_SETTING_ID = "backup";
    public static final String HUB_URL_VALIDATION_RESULT_KEY = "hub-url";
    public static final String HUB_HOME_URL_VALIDATION_RESULT_KEY = "hub-home-url";
    public static final String HUB_LICENSE_VALIDATION_RESULT_KEY = "hub-license";
    @NotNull
    final MigrationServicesProvider myMigrationServicesProvider;
    protected Logger LOG = LoggerFactory.getLogger(this.getClass());

    public HubMigrationAction(@NotNull MigrationServicesProvider migrationServicesProvider) {
        this.myMigrationServicesProvider = migrationServicesProvider;
    }

    abstract T execute() throws AdminConsoleException;

    abstract boolean isReadOnly();

    protected final void setMigrationStatus(@NotNull MigrationStatusEnum statusEnum) throws AdminConsoleException {
        this.setMigrationStatusAndMessage(statusEnum, null);
    }

    protected final void setMigrationStatusAndMessage(final @NotNull MigrationStatusEnum statusEnum, final @Nullable String message) throws AdminConsoleException {
        this.updateMigrationState(new HubMigrationHolder.WriteMigration(){

            @Override
            public Void call(Migration migration) throws AdminConsoleException {
                migration.getStatus().setStatus(statusEnum);
                if (message != null) {
                    migration.getStatus().setMessage(message);
                }
                return null;
            }
        });
    }

    protected final void assertExternalHubToken(@Nullable String externalHubToken) throws AdminConsoleException {
        this.checkIfMigrationExists();
        MigrationInterface migration = this.getMigration();
        if (!migration.isServiceVerified() && (externalHubToken == null || externalHubToken.trim().isEmpty())) {
            throw new AdminConsoleException(ErrorMessage.ACCESS_TOKEN_IS_REQUIRED_FOR_NOT_VERIFIED_SERVICE, migration.getExternalHubServiceId(), migration.getExternalHubUrl());
        }
    }

    protected final void checkIfMigrationExists() throws ObjectNotFoundException {
        if (!this.myMigrationServicesProvider.getHubMigrationHolder().exists()) {
            throw new ObjectNotFoundException("Migration", null);
        }
    }

    public void setInternalHubReadOnlyMode(boolean isReadOnly) {
        HubSettings hubSettings = this.myMigrationServicesProvider.getAdminConsoleExtension().getHubSettings();
        this.setInternalHubReadOnlyMode(isReadOnly, hubSettings);
    }

    public void setInternalHubReadOnlyMode(boolean isReadOnly, @NotNull HubSettings hubSettings) {
        if (!hubSettings.isInternal()) {
            throw new RuntimeException("Can not create backup of internal Hub, because it is disabled");
        }
        BackupSettingsJSON backupSettings = new BackupSettingsJSON();
        backupSettings.setDatabaseReadonly(Boolean.valueOf(isReadOnly));
        this.getBundleHubClient(hubSettings).getBundleHubAccountsClient().getSettingsClient().updateSetting(BACKUP_SETTING_ID, (SettingsJSON)backupSettings);
    }

    protected final MigrationStatusInfo getMigrationStatusInfo(String externalHubToken) throws AdminConsoleException {
        GetStatusAction getStatusAction = new GetStatusAction(externalHubToken, this.myMigrationServicesProvider);
        return this.myMigrationServicesProvider.getHubActionExecutor().execute(getStatusAction);
    }

    @NotNull
    protected final ImportClient getImportClient(@Nullable String externalHubToken) throws AdminConsoleException {
        this.assertExternalHubToken(externalHubToken);
        BaseAccountsClient externalHubAccountsClient = this.getExternalHubAccountsClient();
        externalHubAccountsClient.getRootResource().property("jersey.config.client.request.entity.processing", (Object)RequestEntityProcessing.CHUNKED);
        return this.getMigration().isServiceVerified() ? externalHubAccountsClient.getImportClient() : new ImportClient(externalHubAccountsClient.getRootResource(), (TokenHolder)new OneTimeTokenHolder((AuthToken)AccessToken.decode((String)externalHubToken)));
    }

    @NotNull
    protected final ServiceClient getServiceClient(@Nullable String externalHubToken) throws AdminConsoleException {
        this.assertExternalHubToken(externalHubToken);
        return this.getMigration().isServiceVerified() ? this.getExternalHubAccountsClient().getServiceClient() : new ServiceClient(this.getExternalHubAccountsClient().getRootResource(), (TokenHolder)new OneTimeTokenHolder((AuthToken)AccessToken.decode((String)externalHubToken)));
    }

    @NotNull
    protected final BaseAccountsClient getExternalHubAccountsClient() throws AdminConsoleException {
        MigrationInterface migration = this.getMigration();
        return migration.isServiceVerified() ? this.getHubClient(migration.getExternalHubUrl()).getAccountsClient(migration.getExternalHubServiceId(), migration.getExternalHubServiceSecret(), new String[0]) : this.getHubClient(migration.getExternalHubUrl()).getAccountsClient();
    }

    @NotNull
    protected final HubClient getHubClient(@NotNull String hubUrl) throws ExternalHubValidationException {
        try {
            return this.myMigrationServicesProvider.getHubClientProvider().getHubClient(hubUrl);
        }
        catch (Exception e) {
            ValidationResult validationResult = new ValidationResult();
            validationResult.addError((Enum)ValidationResult.Error.INVALID_HUB_URL, HUB_URL_VALIDATION_RESULT_KEY, e.getMessage());
            throw new ExternalHubValidationException(validationResult, (Throwable)e, hubUrl);
        }
    }

    protected final void removeServiceFromExternalHub(@Nullable String externalHubToken) {
        MigrationInterface migration = this.getMigration();
        if (migration.getExternalHubUrl() != null && migration.getExternalHubServiceId() != null && migration.getExternalHubServiceSecret() != null) {
            try {
                this.assertExternalHubToken(externalHubToken);
                BaseAccountsClient accountsClient = migration.isServiceVerified() ? this.getHubClient(migration.getExternalHubUrl()).getAccountsClient(migration.getExternalHubServiceId(), migration.getExternalHubServiceSecret(), new String[0]) : (externalHubToken != null ? this.getHubClient(migration.getExternalHubUrl()).getAccountsClient((TokenHolder)new OneTimeTokenHolder((AuthToken)AccessToken.decode((String)externalHubToken))) : this.getHubClient(migration.getExternalHubUrl()).getAccountsClient());
                Boolean serviceExists = HubUtil.checkService((BaseAccountsClient)accountsClient).exists();
                if (serviceExists != null && serviceExists.booleanValue()) {
                    ServiceClient serviceClient = accountsClient.getServiceClient();
                    serviceClient.deleteService(migration.getExternalHubServiceId());
                }
            }
            catch (AdminConsoleException e) {
                this.LOG.debug(String.format("Failed to remove temporary service %s from external Hub %s", migration.getExternalHubServiceId(), migration.getExternalHubUrl()), (Throwable)e);
                try {
                    ServiceClient serviceClient = this.getHubClient(migration.getExternalHubUrl()).getAccountsClient(migration.getExternalHubServiceId(), migration.getExternalHubServiceSecret(), new String[0]).getServiceClient();
                    serviceClient.deleteService(migration.getExternalHubServiceId());
                }
                catch (Exception e2) {
                    this.LOG.warn(String.format("Failed to remove temporary service %s from external Hub %s with help of service credentials (without authorization token)", migration.getExternalHubServiceId(), migration.getExternalHubUrl()));
                }
            }
            catch (Exception e) {
                this.LOG.warn(String.format("Failed to remove temporary service %s from external Hub %s", migration.getExternalHubServiceId(), migration.getExternalHubUrl()));
            }
        } else {
            this.LOG.debug(String.format("Migration does not contain enough data about service in External Hub [hubUrl=%s,serviceId=%s,secret%s]", migration.getExternalHubUrl(), migration.getExternalHubServiceId(), migration.getExternalHubUrl() != null ? " is not null" : " is not set"));
        }
    }

    protected final MigrationInterface getMigration() {
        if (this.isReadOnly()) {
            return this.myMigrationServicesProvider.getHubMigrationHolder().getMigrationCopy();
        }
        return this.myMigrationServicesProvider.getHubMigrationHolder().getMigration();
    }

    protected final void updateMigrationState(HubMigrationHolder.WriteMigration updateMigration) throws AdminConsoleException {
        if (this.isReadOnly()) {
            throw new IllegalStateException("Read only action can not update migration state");
        }
        this.myMigrationServicesProvider.getHubMigrationHolder().write(updateMigration);
    }

    protected final <K> K readMigrationState(HubMigrationHolder.ReadMigration<K> readMigration) throws AdminConsoleException {
        return this.myMigrationServicesProvider.getHubMigrationHolder().read(readMigration);
    }

    protected final void initMigrationState(@NotNull String hubUrl, boolean relinkAfterImport) throws AdminConsoleException {
        if (this.isReadOnly()) {
            throw new IllegalStateException("Read only action can not update migration state");
        }
        this.myMigrationServicesProvider.getHubMigrationHolder().initMigrationState(hubUrl, relinkAfterImport);
    }

    protected final void clearMigrationState() throws AdminConsoleException {
        if (this.isReadOnly()) {
            throw new IllegalStateException("Read only action can not update migration state");
        }
        this.myMigrationServicesProvider.getHubMigrationHolder().clearMigrationState();
    }

    protected final AdminConsoleExtension getAdminConsoleExtension() {
        return this.myMigrationServicesProvider.getHubMigrationHolder().getAdminConsoleExtension();
    }

    @NotNull
    protected final BundleHubClient getBundleHubClient(@NotNull HubSettings hubSettings) {
        return BundleHubClient.getBundleHubClient((String)hubSettings.getInternalUrl(), (String)hubSettings.getServiceId(), (String)hubSettings.getServiceSecret(), (boolean)hubSettings.isInternal(), (HubClientProvider)this.myMigrationServicesProvider.getHubClientProvider());
    }

    @NotNull
    protected String validateExternalHubUrl(@NotNull String hubUrl) throws ExternalHubValidationException {
        HubUrlValidator validator = this.myMigrationServicesProvider.getHubUrlValidator();
        ValidationResult validationResult = new ValidationResult();
        String resultHubUrl = validator.validate(hubUrl, validationResult, HUB_URL_VALIDATION_RESULT_KEY, true);
        if (validationResult.hasErrors()) {
            throw new ExternalHubValidationException(validationResult, hubUrl);
        }
        return resultHubUrl;
    }

    @NotNull
    public ExternalHubInfo getAndValidateExternalHubHomeUrl(@NotNull String hubUrl, @NotNull IServiceClientFactory serviceClientFactory, String serviceId) throws AdminConsoleException {
        HubUrlValidator validator = this.myMigrationServicesProvider.getHubUrlValidator();
        ValidationResult validationResult = new ValidationResult();
        HubClient hubClient = this.getHubClient(hubUrl);
        HubHomeUrlInfo info = validator.getHubHomeUrlInfo(hubClient, serviceId, serviceClientFactory, validationResult, HUB_HOME_URL_VALIDATION_RESULT_KEY);
        if (validationResult.hasErrors()) {
            throw new ExternalHubValidationException(validationResult, hubUrl);
        }
        return new ExternalHubInfo(info.isHubHomeUrlIsAvailable(), hubUrl, info.getHubHomeUrl());
    }

    public void checkExternalHubAllowMigration(@NotNull String hubUrl, @NotNull IServiceClientFactory serviceClientFactory) throws AdminConsoleException {
        HubUrlValidator validator = this.myMigrationServicesProvider.getHubUrlValidator();
        ValidationResult validationResult = new ValidationResult();
        HubClient hubClient = this.getHubClient(hubUrl);
        ServiceClient serviceClient = serviceClientFactory.createServiceClient(hubClient);
        validator.validateLicense(hubClient, serviceClient, validationResult, HUB_LICENSE_VALIDATION_RESULT_KEY);
        if (validationResult.hasErrors()) {
            throw new ExternalHubNotAllowedMigrationException(hubUrl);
        }
    }
}

