/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.awc.service.impl.actions;

import com.jetbrains.bundle.api.internal.awc.ext.AdminConsoleExtension;
import com.jetbrains.bundle.api.internal.awc.ext.model.migration.Migration;
import com.jetbrains.bundle.api.internal.awc.ext.model.migration.MigrationInterface;
import com.jetbrains.bundle.awc.exceptions.AdminConsoleException;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class HubMigrationHolder {
    private final ReentrantReadWriteLock migrationStateLock = new ReentrantReadWriteLock();
    private Migration myMigration;
    private final AdminConsoleExtension myAdminConsoleExtension;

    public HubMigrationHolder(@NotNull AdminConsoleExtension adminConsoleExtension) {
        this.myAdminConsoleExtension = adminConsoleExtension;
        this.myMigration = adminConsoleExtension.getMigration();
    }

    final void write(WriteMigration callableWrite) throws AdminConsoleException {
        try {
            this.migrationStateLock.writeLock().lock();
            callableWrite.call(this.myMigration);
            this.myAdminConsoleExtension.storeMigration(this.myMigration);
        }
        finally {
            this.migrationStateLock.writeLock().unlock();
        }
    }

    final <K> K read(ReadMigration<K> callableRead) throws AdminConsoleException {
        try {
            this.migrationStateLock.readLock().lock();
            Object v = callableRead.call(this.myMigration);
            return (K)v;
        }
        finally {
            this.migrationStateLock.readLock().unlock();
        }
    }

    final void initMigrationState(@NotNull String hubUrl, boolean relinkAfterImport) {
        try {
            this.migrationStateLock.writeLock().lock();
            if (this.myMigration == null) {
                this.myMigration = new Migration();
            }
            this.myMigration.setExternalHubUrl(hubUrl);
            this.myMigration.setIsRelinkAfterImport(relinkAfterImport);
            this.myMigration.setIsActive(true);
        }
        finally {
            this.migrationStateLock.writeLock().unlock();
        }
    }

    final void clearMigrationState() {
        this.clearMigrationState(false);
    }

    private void clearMigrationState(boolean backup) {
        try {
            this.migrationStateLock.writeLock().lock();
            this.myMigration = null;
            this.myAdminConsoleExtension.deleteMigration(backup);
        }
        finally {
            this.migrationStateLock.writeLock().unlock();
        }
    }

    final MigrationInterface getMigration() {
        try {
            this.migrationStateLock.readLock().lock();
            Migration migration = this.myMigration;
            return migration;
        }
        finally {
            this.migrationStateLock.readLock().unlock();
        }
    }

    final MigrationInterface getMigrationCopy() {
        try {
            this.migrationStateLock.readLock().lock();
            Migration migration = this.myMigration != null ? this.myMigration.clone() : null;
            return migration;
        }
        finally {
            this.migrationStateLock.readLock().unlock();
        }
    }

    final boolean exists() {
        try {
            this.migrationStateLock.readLock().lock();
            boolean bl = this.myMigration != null;
            return bl;
        }
        finally {
            this.migrationStateLock.readLock().unlock();
        }
    }

    final AdminConsoleExtension getAdminConsoleExtension() {
        return this.myAdminConsoleExtension;
    }

    @Component
    public static class ResetMigrationOnStartUpContextListener
    implements ServletContextListener {
        @Autowired
        HubMigrationHolder myHubMigrationHolder;

        public void contextInitialized(ServletContextEvent sce) {
            WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)sce.getServletContext()).getAutowireCapableBeanFactory().autowireBean((Object)this);
            this.myHubMigrationHolder.clearMigrationState(true);
        }

        public void contextDestroyed(ServletContextEvent sce) {
        }
    }

    protected static interface Callable<M extends MigrationInterface, V, E extends Throwable> {
        public V call(M var1) throws E;
    }

    protected static abstract class ReadMigration<T>
    implements Callable<MigrationInterface, T, AdminConsoleException> {
        protected ReadMigration() {
        }
    }

    protected static abstract class WriteMigration
    implements Callable<Migration, Void, AdminConsoleException> {
        protected WriteMigration() {
        }
    }
}

