/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.awc.service.impl.actions;

import com.intellij.hub.auth.AuthToken;
import com.intellij.hub.auth.basic.BasicAuthToken;
import com.intellij.hub.auth.oauth2.consumer.OneTimeTokenHolder;
import com.intellij.hub.auth.oauth2.consumer.TokenHolder;
import com.intellij.hub.auth.oauth2.token.AccessToken;
import com.jetbrains.bundle.api.internal.awc.ext.model.HubSettings;
import com.jetbrains.bundle.api.internal.awc.ext.model.migration.Migration;
import com.jetbrains.bundle.api.internal.awc.ext.model.migration.MigrationInterface;
import com.jetbrains.bundle.awc.exceptions.AdminConsoleException;
import com.jetbrains.bundle.awc.exceptions.ErrorMessage;
import com.jetbrains.bundle.awc.exceptions.ExternalHubValidationException;
import com.jetbrains.bundle.awc.service.MigrationServicesProvider;
import com.jetbrains.bundle.awc.service.impl.actions.HubMigrationAction;
import com.jetbrains.bundle.awc.service.impl.actions.HubMigrationHolder;
import com.jetbrains.bundle.hub_client.util.HubServiceCheckResult;
import com.jetbrains.bundle.hub_client.util.HubUtil;
import com.jetbrains.bundle.hub_client.util.validation.DefaultServiceClientFactory;
import com.jetbrains.bundle.hub_client.util.validation.IServiceClientFactory;
import com.jetbrains.bundle.hub_client.util.validation.ValidationResult;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Objects;
import javax.ws.rs.ForbiddenException;
import jetbrains.jetpass.client.BaseField;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.accounts.BaseAccountsClient;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.client.accounts.ServiceClient;
import jetbrains.jetpass.client.accounts.SettingClient;
import jetbrains.jetpass.client.hub.HubClient;
import jetbrains.jetpass.rest.dto.ServiceJSON;
import jetbrains.jetpass.rest.dto.SettingsJSON;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrepareMigrationAction
extends HubMigrationAction<MigrationInterface> {
    public static final String HUB_TO_HUB_MIGRATION_SERVICE_APPLICATION_NAME = "Hub Exporter";
    public static final String MANUFACTURER = "JetBrains";
    @NotNull
    private final String myHubUrl;
    private final String myRedirectUriForExternalHubService;
    private final String myUserLogin;
    private final String myUserPassword;
    private final boolean myRelinkAfterImportFlag;

    public PrepareMigrationAction(@NotNull String hubUrl, String redirectUriForExternalHubService, @Nullable String userLogin, @Nullable String userPassword, @NotNull MigrationServicesProvider migrationServicesProvider, boolean relinkAfterImport) {
        super(migrationServicesProvider);
        this.myHubUrl = hubUrl;
        this.myRedirectUriForExternalHubService = redirectUriForExternalHubService;
        this.myUserLogin = userLogin;
        this.myUserPassword = userPassword;
        this.myRelinkAfterImportFlag = relinkAfterImport;
    }

    @Override
    boolean isReadOnly() {
        return false;
    }

    @Override
    @NotNull
    MigrationInterface execute() throws AdminConsoleException {
        HubSettings hubSettings = this.getAdminConsoleExtension().getHubSettings();
        if (!hubSettings.isInternal()) {
            throw new AdminConsoleException("Product doesn't contain internal Hub");
        }
        if (this.myRelinkAfterImportFlag && !hubSettings.isRelinkToExternalHubAllowed()) {
            throw new AdminConsoleException(ErrorMessage.RELINK_TO_EXTERNAL_HUB_AFTER_IMPORT_IS_NOT_ALLOWED, new String[0]);
        }
        MigrationInterface migration = this.getMigration();
        if (migration == null || migration.getExternalHubUrl() == null) {
            String validHubUrl = this.validateExternalHubUrl(this.myHubUrl);
            this.initMigrationState(validHubUrl, this.myRelinkAfterImportFlag);
        }
        if ((migration = this.getMigration()).getExternalHubServiceId() == null || migration.getExternalHubServiceSecret() == null) {
            HubClient hubClient = this.getHubClient(migration.getExternalHubUrl());
            boolean serviceCreated = false;
            while (!serviceCreated) {
                boolean isServiceVerified;
                String serviceSecret;
                String serviceId = HubUtil.generateHubServiceId();
                HubServiceCheckResult checkResult = HubUtil.checkService((BaseAccountsClient)hubClient.getAccountsClient(serviceId, serviceSecret = HubUtil.generateHubServiceSecret(), new String[0]));
                if (checkResult.getStatus() == HubServiceCheckResult.Status.CANNOT_CHECK) {
                    throw new AdminConsoleException(ErrorMessage.EXTERNAL_HUB_ERROR, checkResult.getCause(), new String[0]);
                }
                Boolean exists = checkResult.exists();
                if (exists == null || exists.booleanValue()) continue;
                if (this.myUserLogin != null && this.myUserPassword != null) {
                    OneTimeTokenHolder holder = new OneTimeTokenHolder((AuthToken)new BasicAuthToken(this.myUserLogin, this.myUserPassword));
                    BaseAccountsClient accountsClient = hubClient.getAccountsClient((TokenHolder)holder);
                    ServiceClient serviceClient = accountsClient.getServiceClient();
                    ServiceJSON createdService = HubUtil.createService((ServiceClient)serviceClient, (String)serviceId, (String)serviceSecret, (String)this.getHubToHubMigrationServiceName(), (String)HUB_TO_HUB_MIGRATION_SERVICE_APPLICATION_NAME, (String)MANUFACTURER, null, Collections.singletonList(this.myRedirectUriForExternalHubService));
                    isServiceVerified = Boolean.TRUE.equals(createdService.isTrusted());
                } else {
                    try {
                        ServiceJSON createdService = HubUtil.createService((HubClient)hubClient, (String)serviceId, (String)serviceSecret, (String)this.getHubToHubMigrationServiceName(), (String)HUB_TO_HUB_MIGRATION_SERVICE_APPLICATION_NAME, (String)MANUFACTURER, null, Collections.singletonList(this.myRedirectUriForExternalHubService));
                        isServiceVerified = Boolean.TRUE.equals(createdService.isTrusted());
                    }
                    catch (ForbiddenException e) {
                        throw new AdminConsoleException(ErrorMessage.COULD_NOT_CREATE_SERVICE_IN_EXTERNAL_HUB_ANONYMOUSLY, (Throwable)e, new String[0]);
                    }
                }
                this.setMigrationServiceInfo(serviceId, serviceSecret, isServiceVerified);
                serviceCreated = true;
            }
        }
        return this.getMigration();
    }

    @Override
    @NotNull
    protected String validateExternalHubUrl(@NotNull String hubUrl) throws ExternalHubValidationException {
        String validHubUrl = super.validateExternalHubUrl(this.myHubUrl);
        this.checkIfExternalHubUrlPointsToAnotherHub(hubUrl, validHubUrl);
        return validHubUrl;
    }

    private void checkIfExternalHubUrlPointsToAnotherHub(@NotNull String hubUrl, String validHubUrl) throws ExternalHubValidationException {
        HubSettings hubSettings = this.myMigrationServicesProvider.getAdminConsoleExtension().getHubSettings();
        SettingClient settingsClientOfCurrentHub = this.getBundleHubClient(hubSettings).getHubClient().getAccountsClient().getSettingsClient();
        SettingsJSON currentPublicSettings = settingsClientOfCurrentHub.getSetting("public", new FieldPartial((BaseField[])new Partial.Settings[]{Partial.PublicSettings.ID}));
        SettingClient settingsClientOfExternalHub = this.getHubClient(validHubUrl).getAccountsClient().getSettingsClient();
        SettingsJSON externalPublicSettings = settingsClientOfExternalHub.getSetting("public", new FieldPartial((BaseField[])new Partial.Settings[]{Partial.PublicSettings.ID}));
        if (currentPublicSettings != null && currentPublicSettings.getId() != null && externalPublicSettings != null && Objects.equals(currentPublicSettings.getId(), externalPublicSettings.getId())) {
            ValidationResult validationResult = new ValidationResult();
            validationResult.addError((Enum)ValidationResult.Error.INVALID_HUB_URL, "hub-url", String.format("This URL either points or is redirected to the internal Hub service that is currently used by %s. Enter the base URL of your external Hub service or update the settings for your proxy server.", this.myMigrationServicesProvider.getAdminConsoleExtension().getProductState().getProductName()));
            throw new ExternalHubValidationException(validationResult, hubUrl);
        }
    }

    @NotNull
    private IServiceClientFactory getServiceClientFactory(final String externalHubToken) throws AdminConsoleException {
        this.assertExternalHubToken(externalHubToken);
        Object serviceClientFactory = this.getMigration().isServiceVerified() ? new DefaultServiceClientFactory(this.getMigration().getExternalHubServiceId(), this.getMigration().getExternalHubServiceSecret()) : new IServiceClientFactory(){

            public ServiceClient createServiceClient(@NotNull HubClient hubClient) {
                return new ServiceClient(hubClient.getAccountsClient().getRootResource(), (TokenHolder)new OneTimeTokenHolder((AuthToken)AccessToken.decode((String)externalHubToken)));
            }
        };
        return serviceClientFactory;
    }

    private void setMigrationServiceInfo(final String serviceId, final String serviceSecret, final boolean isServiceVerified) throws AdminConsoleException {
        this.updateMigrationState(new HubMigrationHolder.WriteMigration(){

            @Override
            public Void call(Migration migration) {
                migration.setExternalHubServiceId(serviceId);
                migration.setExternalHubServiceSecret(serviceSecret);
                migration.setIsServiceVerified(isServiceVerified);
                return null;
            }
        });
    }

    private String getHubToHubMigrationServiceName() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("d MMM yyyy HH:mm z");
        String dateTime = dateFormat.format(new Date());
        return String.format("%s Service (%s)", this.myRelinkAfterImportFlag ? "Migration" : "Export", dateTime);
    }
}

