/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.awc.service.impl.actions;

import com.jetbrains.bundle.api.internal.awc.ext.AdminConsoleExtension;
import com.jetbrains.bundle.api.internal.awc.ext.model.HubSettings;
import com.jetbrains.bundle.api.internal.awc.ext.model.migration.Migration;
import com.jetbrains.bundle.api.internal.awc.ext.model.migration.MigrationStatus;
import com.jetbrains.bundle.api.internal.awc.ext.model.migration.MigrationStatusEnum;
import com.jetbrains.bundle.awc.exceptions.AdminConsoleException;
import com.jetbrains.bundle.awc.exceptions.ErrorMessage;
import com.jetbrains.bundle.awc.exceptions.ExternalHubIsTooOldException;
import com.jetbrains.bundle.awc.exceptions.ExternalHubValidationException;
import com.jetbrains.bundle.awc.exceptions.ExternalHubWrappedException;
import com.jetbrains.bundle.awc.exceptions.HubHomeUrlUnavailableException;
import com.jetbrains.bundle.awc.exceptions.ImportForbiddenException;
import com.jetbrains.bundle.awc.model.ExternalHubInfo;
import com.jetbrains.bundle.awc.service.MigrationServicesProvider;
import com.jetbrains.bundle.awc.service.impl.actions.HubMigrationAction;
import com.jetbrains.bundle.awc.service.impl.actions.HubMigrationHolder;
import com.jetbrains.bundle.hub_client.util.BundleHubClient;
import com.jetbrains.bundle.hub_client.util.HubUtil;
import com.jetbrains.bundle.hub_client.util.validation.IServiceClientFactory;
import com.jetbrains.service.util.Version;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import jetbrains.jetpass.client.BaseField;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.accounts.ImportClient;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.client.accounts.ServiceClient;
import jetbrains.jetpass.client.hub.HubClient;
import jetbrains.jetpass.hub2hub.dto.ImportJSON;
import jetbrains.jetpass.rest.dto.BackupDataJSON;
import jetbrains.jetpass.rest.dto.BackupSettingsJSON;
import jetbrains.jetpass.rest.dto.ServiceJSON;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StartMigrationAction
extends HubMigrationAction<Void> {
    private static Comparator<BackupData> BACKUP_DATA_COMPARATOR = new BackupDataJSONComparator();
    private static final Pattern HUB_VERSION_FORMAT = Pattern.compile("\\d+\\.\\d+\\.\\d+");
    @Nullable
    private final String myExternalHubToken;
    @NotNull
    private final String myReferrerUrl;
    @NotNull
    private final AdminConsoleExtension myAdminConsoleExtension;
    private final Object timedWaitMonitor = new Object();
    private boolean myHubUrlConfirmed;

    public StartMigrationAction(@Nullable String externalHubToken, @NotNull String referrerUrl, boolean hubUrlConfirmed, @NotNull MigrationServicesProvider migrationServicesProvider) {
        super(migrationServicesProvider);
        this.myExternalHubToken = externalHubToken;
        this.myReferrerUrl = referrerUrl;
        this.myAdminConsoleExtension = migrationServicesProvider.getAdminConsoleExtension();
        this.myHubUrlConfirmed = hubUrlConfirmed;
    }

    @Override
    boolean isReadOnly() {
        return false;
    }

    @Override
    Void execute() throws AdminConsoleException {
        this.assertExternalHubToken(this.myExternalHubToken);
        this.initMigrationStatus();
        if (!this.getMigration().isActive()) {
            this.setMigrationState();
        }
        HubSettings hubSettings = this.myAdminConsoleExtension.getHubSettings();
        if (this.getMigration().getStatus().getStatus().isLesserThan(MigrationStatusEnum.SWITCH_TO_READ_ONLY_MODE)) {
            this.checkIfMigrationToExternalHubIsPossible();
            try {
                this.setMigrationStatus(MigrationStatusEnum.SWITCH_TO_READ_ONLY_MODE);
                this.setInternalHubReadOnlyMode(true, hubSettings);
            }
            catch (Throwable e) {
                this.rollbackReadOnlyMode(hubSettings, this.extractStatus(e, MigrationStatusEnum.SWITCH_TO_READ_ONLY_MODE_FAILED), e);
                throw new AdminConsoleException("Could not switch Hub to read only mode", e);
            }
        }
        if (this.getMigration().getStatus().getStatus() == MigrationStatusEnum.SWITCH_TO_READ_ONLY_MODE) {
            try {
                String externalHubVersion = this.getExternalHubVersion();
                this.setMigrationStatus(MigrationStatusEnum.BACKUP);
                File file = this.createInternalHubBackup(hubSettings, externalHubVersion);
                this.setMigrationBackupFilePath(file);
            }
            catch (Throwable e) {
                this.rollbackReadOnlyMode(hubSettings, this.extractStatus(e, MigrationStatusEnum.BACKUP_FAILED), e);
                throw new AdminConsoleException("Could make back up of internal Hub", e);
            }
        }
        if (this.getMigration().getStatus().getStatus() == MigrationStatusEnum.BACKUP) {
            try {
                this.setMigrationStatus(MigrationStatusEnum.UPLOAD);
                ImportJSON importJSON = this.upload(this.myExternalHubToken, new File(this.getMigration().getBackupFilePath()), hubSettings);
                this.setMigrationId(importJSON);
            }
            catch (Throwable e) {
                this.rollbackReadOnlyMode(hubSettings, this.extractStatus(e, MigrationStatusEnum.UPLOAD_FAILED), e);
                throw e;
            }
        }
        return null;
    }

    private void checkIfMigrationToExternalHubIsPossible() throws AdminConsoleException {
        IServiceClientFactory serviceClientFactory = new IServiceClientFactory(){

            public ServiceClient createServiceClient(@NotNull HubClient hubClient) {
                try {
                    return StartMigrationAction.this.getServiceClient(StartMigrationAction.this.myExternalHubToken);
                }
                catch (AdminConsoleException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.checkExternalHubAllowMigration(this.getMigration().getExternalHubUrl(), serviceClientFactory);
        this.checkTargetHubVersion(this.getMigration().getExternalHubUrl(), serviceClientFactory);
        if (this.getMigration().getExternalHubHomeUrl() == null) {
            if (this.myExternalHubToken != null || this.getMigration().isServiceVerified()) {
                ExternalHubInfo info = this.getAndValidateExternalHubHomeUrl(this.getMigration().getExternalHubUrl(), serviceClientFactory, this.getMigration().getExternalHubServiceId());
                if (!info.isHubHomeUrlAvailable() && !this.myHubUrlConfirmed) {
                    throw new HubHomeUrlUnavailableException(info.getHubHomeUrl());
                }
                this.setMigrationHubHomeUrlInfo(info.getHubHomeUrl(), info.isHubHomeUrlAvailable());
            } else {
                throw new AdminConsoleException(ErrorMessage.UNEXPECTED, "Hub token or verified service is required!");
            }
        }
    }

    @NotNull
    private MigrationStatusEnum extractStatus(Throwable e, MigrationStatusEnum defaultErrorStatus) {
        ProcessingException exception;
        MigrationStatusEnum status = defaultErrorStatus;
        if (e.getCause() instanceof ProcessingException && (exception = (ProcessingException)e.getCause()).getCause() instanceof OutOfMemoryError) {
            status = MigrationStatusEnum.OOM_FAILED;
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollbackReadOnlyMode(@NotNull HubSettings hubSettings, @NotNull MigrationStatusEnum status, @Nullable Throwable e) throws AdminConsoleException {
        try {
            this.setInternalHubReadOnlyMode(false, hubSettings);
        }
        catch (Throwable t) {
            this.LOG.debug("Cannot switch to ReadOnly mode", t);
        }
        finally {
            String message = null;
            if (e != null && e.getCause() instanceof RuntimeException) {
                message = e.getCause().getMessage();
            }
            this.setMigrationStatusAndMessage(status, message);
        }
    }

    private void setMigrationId(final ImportJSON importJSON) throws AdminConsoleException {
        this.updateMigrationState(new HubMigrationHolder.WriteMigration(){

            @Override
            public Void call(Migration migration) throws AdminConsoleException {
                migration.setExternalHubMigrationId(importJSON.getId());
                return null;
            }
        });
    }

    private void setMigrationBackupFilePath(final File file) throws AdminConsoleException {
        this.updateMigrationState(new HubMigrationHolder.WriteMigration(){

            @Override
            public Void call(Migration migration) throws AdminConsoleException {
                migration.setBackupFilePath(file.getAbsolutePath());
                return null;
            }
        });
    }

    private void initMigrationStatus() throws AdminConsoleException {
        this.updateMigrationState(new HubMigrationHolder.WriteMigration(){

            @Override
            public Void call(Migration migration) throws AdminConsoleException {
                if (migration.getStatus() == null) {
                    MigrationStatus migrationStatus = new MigrationStatus();
                    migrationStatus.setStatus(MigrationStatusEnum.STARTING);
                    migration.setStatus(migrationStatus);
                }
                return null;
            }
        });
    }

    private void setMigrationState() throws AdminConsoleException {
        this.updateMigrationState(new HubMigrationHolder.WriteMigration(){

            @Override
            public Void call(Migration migration) throws AdminConsoleException {
                migration.setIsActive(true);
                return null;
            }
        });
    }

    private void setMigrationHubHomeUrlInfo(final String hubHomeUrl, final boolean hubHomeUrlAvailable) throws AdminConsoleException {
        this.updateMigrationState(new HubMigrationHolder.WriteMigration(){

            @Override
            public Void call(Migration migration) {
                migration.setExternalHubHomeUrl(hubHomeUrl);
                migration.setExternalHubHubHomeUrlAvailable(hubHomeUrlAvailable);
                if (hubHomeUrlAvailable) {
                    migration.setExternalHubUrl(hubHomeUrl);
                }
                return null;
            }
        });
    }

    private ImportJSON upload(@Nullable String externalHubToken, @NotNull File backupFile, @NotNull HubSettings hubSettings) throws AdminConsoleException {
        return this.upload(externalHubToken, backupFile, hubSettings, true);
    }

    private ImportJSON upload(@Nullable String externalHubToken, @NotNull File backupFile, @NotNull HubSettings hubSettings, boolean tryToCleanupConflictingMigrations) throws AdminConsoleException {
        ImportClient importClient = this.getImportClient(externalHubToken);
        try {
            FileInputStream is = new FileInputStream(backupFile);
            return importClient.createImport(hubSettings.getUrl(), this.myReferrerUrl, (InputStream)is, null);
        }
        catch (WebApplicationException e) {
            if (tryToCleanupConflictingMigrations && e.getResponse().getStatus() == 409) {
                this.removeBackedUpMigrations(importClient);
                return this.upload(externalHubToken, backupFile, hubSettings, false);
            }
            if (e.getResponse().getStatus() == 403) {
                throw new ImportForbiddenException(this.getMigration().getExternalHubUrl(), e);
            }
            throw new ExternalHubWrappedException(this.getMigration().getExternalHubUrl(), e);
        }
        catch (Exception e) {
            throw new ExternalHubWrappedException(this.getMigration().getExternalHubUrl(), e);
        }
    }

    private void removeBackedUpMigrations(ImportClient importClient) {
        Collection backedUpMigrations = this.getAdminConsoleExtension().getBackedUpMigrations();
        for (Migration backedUpMigration : backedUpMigrations) {
            if (backedUpMigration.getExternalHubMigrationId() == null) continue;
            try {
                importClient.deleteImport(backedUpMigration.getExternalHubMigrationId());
            }
            catch (Exception ignored) {
                this.LOG.debug(String.format("Failed to delete import with id %s from Hub %s", backedUpMigration.getExternalHubMigrationId(), this.getMigration().getExternalHubUrl()), (Throwable)ignored);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createInternalHubBackup(@NotNull HubSettings hubSettings, @Nullable String externalHubVersion) {
        if (!hubSettings.isInternal()) {
            throw new RuntimeException("Can not create backup of internal Hub, because it is disabled");
        }
        BundleHubClient bundleHubClient = this.getBundleHubClient(hubSettings);
        Path backupDirectoryPath = this.getHubBackupDirectory(bundleHubClient);
        List<BackupData> existingBackups = this.loadBackups(bundleHubClient);
        bundleHubClient.getBundleHubAccountsClient().getSettingsClient().backupData(externalHubVersion, null);
        BackupSettingsJSON backupStatusJSON = null;
        while (backupStatusJSON == null || StartMigrationAction.isBackupInProgress(backupStatusJSON)) {
            if (backupStatusJSON != null) {
                try {
                    Object object = this.timedWaitMonitor;
                    synchronized (object) {
                        this.timedWaitMonitor.wait(100L);
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Interrupted while waiting for backup ready", e);
                }
            }
            backupStatusJSON = this.loadBackupSettingJSON(bundleHubClient);
        }
        String backupName = null;
        for (int attemptsCounter = 0; backupName == null && attemptsCounter < 3; ++attemptsCounter) {
            if (attemptsCounter > 0) {
                try {
                    Object object = this.timedWaitMonitor;
                    synchronized (object) {
                        this.timedWaitMonitor.wait(100L);
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Interrupted while waiting for backup ready", e);
                }
                backupStatusJSON = this.loadBackupSettingJSON(bundleHubClient);
            }
            if (StartMigrationAction.isBackupInProgress(backupStatusJSON)) continue;
            List<BackupData> reloadedBackups = this.loadBackups(bundleHubClient);
            reloadedBackups.removeAll(existingBackups);
            if (reloadedBackups.isEmpty()) continue;
            BackupData latestBackUp = Collections.max(reloadedBackups, BACKUP_DATA_COMPARATOR);
            backupName = latestBackUp.backupDataJSON.getName();
        }
        if (backupName == null) {
            throw new RuntimeException("Backup was not created, please see logs of built-in Hub service for more details");
        }
        return backupDirectoryPath.resolve(backupName).toFile();
    }

    private BackupSettingsJSON loadBackupSettingJSON(BundleHubClient bundleHubClient) {
        return (BackupSettingsJSON)bundleHubClient.getBundleHubAccountsClient().getSettingsClient().getSetting("backup", new FieldPartial((BaseField[])new Partial.Settings[]{Partial.BackupSettings.STATUS((Partial.BackupStatus[])new Partial.BackupStatus[]{Partial.BackupStatus.IN_PROGRESS, Partial.BackupStatus.SAVED_DATA((Partial.BackupData[])new Partial.BackupData[]{Partial.BackupData.NAME, Partial.BackupData.TIMESTAMP})})}));
    }

    private static boolean isBackupInProgress(BackupSettingsJSON backupSettingsJSON) {
        if (backupSettingsJSON == null || backupSettingsJSON.getStatus() == null || backupSettingsJSON.getStatus().isInProgress() == null) {
            throw new RuntimeException("Can not get status of backing up");
        }
        return Boolean.TRUE.equals(backupSettingsJSON.getStatus().isInProgress());
    }

    private List<BackupData> loadBackups(BundleHubClient bundleHubClient) {
        Iterable savedDataIterable;
        ArrayList<BackupData> existingBackups = new ArrayList<BackupData>();
        BackupSettingsJSON existingBackupsSettings = this.loadBackupSettingJSON(bundleHubClient);
        if (existingBackupsSettings != null && existingBackupsSettings.getStatus() != null && existingBackupsSettings.getStatus().getSavedData() != null && (savedDataIterable = existingBackupsSettings.getStatus().getSavedData()) != null && savedDataIterable.iterator() != null) {
            for (BackupDataJSON backupDataJSON : savedDataIterable) {
                if (backupDataJSON == null) continue;
                existingBackups.add(new BackupData(backupDataJSON));
            }
        }
        return existingBackups;
    }

    @NotNull
    private Path getHubBackupDirectory(@NotNull BundleHubClient bundleHubClient) {
        BackupSettingsJSON backupSettings = (BackupSettingsJSON)bundleHubClient.getBundleHubAccountsClient().getSettingsClient().getSetting("backup", new FieldPartial((BaseField[])new Partial.Settings[]{Partial.BackupSettings.BACKUP_FOLDER}));
        if (backupSettings == null || backupSettings.getBackupFolder() == null) {
            throw new RuntimeException("can not get backup directory from Hub");
        }
        return Paths.get(backupSettings.getBackupFolder(), new String[0]);
    }

    @Nullable
    private String getExternalHubVersion() throws AdminConsoleException {
        String hubServiceId = HubUtil.getHubServiceId((HubClient)this.getHubClient(this.getMigration().getExternalHubUrl()));
        ServiceJSON externalHubService = this.getServiceClient(this.myExternalHubToken).getService(hubServiceId, new FieldPartial((BaseField[])new Partial.Service[]{Partial.Service.VERSION}));
        if (externalHubService == null) {
            throw new AdminConsoleException("External Hub doesn't return its version");
        }
        return externalHubService.getVersion();
    }

    private void checkTargetHubVersion(@NotNull String hubUrl, @NotNull IServiceClientFactory serviceClientFactory) throws ExternalHubValidationException, ExternalHubIsTooOldException {
        HubSettings hubSettings = this.myMigrationServicesProvider.getAdminConsoleExtension().getHubSettings();
        BundleHubClient bundleHubClient = this.getBundleHubClient(hubSettings);
        String currentHubServiceId = bundleHubClient.getHubClient().getOAuthClient().getHubScope();
        ServiceJSON currentHubService = bundleHubClient.getBundleHubAccountsClient().getServiceClient().getService(currentHubServiceId, new FieldPartial((BaseField[])new Partial.Service[]{Partial.Service.VERSION}));
        Version currentHubVersion = StartMigrationAction.resolveHubServiceVersion(currentHubService);
        HubClient hubClient = this.getHubClient(hubUrl);
        ServiceClient serviceClient = serviceClientFactory.createServiceClient(hubClient);
        String targetHubServiceId = hubClient.getOAuthClient().getHubScope();
        ServiceJSON targetHubService = serviceClient.getService(targetHubServiceId, new FieldPartial((BaseField[])new Partial.Service[]{Partial.Service.VERSION}));
        Version targetHubVersion = StartMigrationAction.resolveHubServiceVersion(targetHubService);
        if (currentHubVersion != null && targetHubVersion != null && targetHubVersion.isLesser(currentHubVersion)) {
            throw new ExternalHubIsTooOldException(targetHubVersion.toString(), currentHubVersion.toString());
        }
    }

    @Nullable
    private static Version resolveHubServiceVersion(ServiceJSON hubService) {
        Matcher matcher;
        String hubVersion;
        String string = hubVersion = hubService != null ? hubService.getVersion() : null;
        if (hubVersion != null && (matcher = HUB_VERSION_FORMAT.matcher(hubVersion)).find()) {
            return Version.parseVersion((String)matcher.group());
        }
        return null;
    }

    private static class BackupData {
        @NotNull
        private final BackupDataJSON backupDataJSON;

        BackupData(@NotNull BackupDataJSON backupDataJSON) {
            this.backupDataJSON = backupDataJSON;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BackupData)) {
                return false;
            }
            BackupData that = (BackupData)o;
            if (this.backupDataJSON.getName() != null ? !this.backupDataJSON.getName().equals(that.backupDataJSON.getName()) : that.backupDataJSON.getName() != null) {
                return false;
            }
            return this.backupDataJSON.getTimestamp() != null ? this.backupDataJSON.getTimestamp().equals(that.backupDataJSON.getTimestamp()) : that.backupDataJSON.getTimestamp() == null;
        }

        public int hashCode() {
            int result = this.backupDataJSON.getName() != null ? this.backupDataJSON.getName().hashCode() : 0;
            result = 31 * result + (this.backupDataJSON.getTimestamp() != null ? this.backupDataJSON.getTimestamp().hashCode() : 0);
            return result;
        }
    }

    private static class BackupDataJSONComparator
    implements Comparator<BackupData> {
        private BackupDataJSONComparator() {
        }

        @Override
        public int compare(BackupData o1, BackupData o2) {
            if (o1 == null || o1.backupDataJSON.getTimestamp() == null) {
                return -1;
            }
            if (o2 == null || o2.backupDataJSON.getTimestamp() == null) {
                return 1;
            }
            return o1.backupDataJSON.getTimestamp().compareTo(o2.backupDataJSON.getTimestamp());
        }
    }
}

