/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.awc.service.impl.actions;

import com.jetbrains.bundle.api.internal.awc.ext.model.HubSettings;
import com.jetbrains.bundle.awc.exceptions.AdminConsoleException;
import com.jetbrains.bundle.awc.model.ExternalHubInfo;
import com.jetbrains.bundle.awc.service.MigrationServicesProvider;
import com.jetbrains.bundle.awc.service.impl.actions.HubMigrationAction;
import com.jetbrains.bundle.awc.service.impl.actions.ValidateBeforeSwitchExternalHubAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SwitchExternalHubAction
extends HubMigrationAction<Void> {
    @Nullable
    final String myUrl;
    private boolean myConfirmedNotUsingHomeUrlFlag;

    public SwitchExternalHubAction(@Nullable String url, @NotNull MigrationServicesProvider migrationServicesProvider, boolean confirmedNotUsingHomeUrl) {
        super(migrationServicesProvider);
        this.myUrl = url;
        this.myConfirmedNotUsingHomeUrlFlag = confirmedNotUsingHomeUrl;
    }

    @Override
    boolean isReadOnly() {
        return false;
    }

    @Override
    Void execute() throws AdminConsoleException {
        HubSettings hubSettings = this.getAdminConsoleExtension().getHubSettings();
        if (this.myUrl == null) {
            if (hubSettings.isInternal()) {
                throw new AdminConsoleException("Can not switch from internal Hub. Product has already used that.");
            }
            this.getAdminConsoleExtension().switchToInternalHub();
        } else {
            if (hubSettings.isInternal()) {
                throw new AdminConsoleException("Can not switch from internal Hub to External without Hub-to-Hub migration.");
            }
            String validHubUrl = this.getValidatedHubUrl(this.myUrl, this.myConfirmedNotUsingHomeUrlFlag);
            this.getAdminConsoleExtension().applyExternalHub(validHubUrl);
        }
        return null;
    }

    @NotNull
    protected final ExternalHubInfo getExternalHubUrlInfo(@NotNull String hubUrl) throws AdminConsoleException {
        ValidateBeforeSwitchExternalHubAction validateBeforeSwitchExternalHubAction = new ValidateBeforeSwitchExternalHubAction(hubUrl, this.myMigrationServicesProvider, this.myConfirmedNotUsingHomeUrlFlag);
        return this.myMigrationServicesProvider.getHubActionExecutor().execute(validateBeforeSwitchExternalHubAction);
    }

    @NotNull
    protected final String getValidatedHubUrl(String hubUrl, boolean hubUrlConfirmed) throws AdminConsoleException {
        ExternalHubInfo externalHubInfo = this.getExternalHubUrlInfo(hubUrl);
        return externalHubInfo.isHubHomeUrlAvailable() ? externalHubInfo.getHubHomeUrl() : externalHubInfo.getHubUrl();
    }
}

