/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.awc.service.impl.actions;

import com.jetbrains.bundle.awc.exceptions.AdminConsoleException;
import com.jetbrains.bundle.awc.exceptions.ErrorMessage;
import com.jetbrains.bundle.awc.exceptions.HubHomeUrlUnavailableException;
import com.jetbrains.bundle.awc.model.ExternalHubInfo;
import com.jetbrains.bundle.awc.service.MigrationServicesProvider;
import com.jetbrains.bundle.awc.service.impl.actions.CheckServicesInExternalHubAction;
import com.jetbrains.bundle.awc.service.impl.actions.HubMigrationAction;
import com.jetbrains.bundle.hub_client.util.validation.DefaultServiceClientFactory;
import com.jetbrains.bundle.hub_client.util.validation.IServiceClientFactory;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ValidateBeforeSwitchExternalHubAction
extends HubMigrationAction<ExternalHubInfo> {
    @NotNull
    final String myHubUrl;
    private boolean myConfirmedNotUsingHomeUrlFlag;

    public ValidateBeforeSwitchExternalHubAction(@NotNull String hubUrl, @NotNull MigrationServicesProvider migrationServicesProvider, boolean confirmedNotUsingHomeUrl) {
        super(migrationServicesProvider);
        this.myHubUrl = hubUrl;
        this.myConfirmedNotUsingHomeUrlFlag = confirmedNotUsingHomeUrl;
    }

    @Override
    boolean isReadOnly() {
        return true;
    }

    @Override
    ExternalHubInfo execute() throws AdminConsoleException {
        String hubUrl = this.validateExternalHubUrl(this.myHubUrl);
        Map<String, String> serviceId2Secret = this.checkProductServicesAreRegisteredInHub(hubUrl);
        if (serviceId2Secret != null && !serviceId2Secret.isEmpty()) {
            String firstServiceId = serviceId2Secret.keySet().iterator().next();
            String firstServiceSecret = serviceId2Secret.get(firstServiceId);
            DefaultServiceClientFactory serviceClientFactory = new DefaultServiceClientFactory(firstServiceId, firstServiceSecret);
            this.checkExternalHubAllowMigration(this.myHubUrl, (IServiceClientFactory)serviceClientFactory);
            ExternalHubInfo externalHubInfo = this.getAndValidateExternalHubHomeUrl(hubUrl, (IServiceClientFactory)serviceClientFactory, firstServiceId);
            if (!externalHubInfo.isHubHomeUrlAvailable() && !this.myConfirmedNotUsingHomeUrlFlag) {
                throw new HubHomeUrlUnavailableException(externalHubInfo.getHubHomeUrl());
            }
            return externalHubInfo;
        }
        throw new AdminConsoleException(ErrorMessage.UNEXPECTED, "No trusted product services found in external Hub");
    }

    private Map<String, String> checkProductServicesAreRegisteredInHub(String hubUrl) throws AdminConsoleException {
        CheckServicesInExternalHubAction checkServicesAction = new CheckServicesInExternalHubAction(hubUrl, this.myMigrationServicesProvider);
        return this.myMigrationServicesProvider.getHubActionExecutor().execute(checkServicesAction);
    }
}

