/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.auth.module.jba.dnq.client;

import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import jetbrains.jetpass.auth.module.dnq.authentication.AuthenticationException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\t"}, d2={"Ljetbrains/jetpass/auth/module/jba/dnq/client/JBAAuthenticationException;", "Ljetbrains/jetpass/auth/module/dnq/authentication/AuthenticationException;", "code", "", "message", "cause", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Throwable;)V", "Companion", "jetbrains.jetpass.auth.module.jba.dnq"})
public final class JBAAuthenticationException
extends AuthenticationException {
    private static final String AUTH_FAILED = "jba-auth-failed";
    private static final String USER_FETCH_FAILED = "jba-user-fetch";
    private static final String RATE_LIMIT_EXCEEDED = "jba-rate-limit";
    public static final Companion Companion = new Companion(null);

    private JBAAuthenticationException(String code, String message, Throwable cause) {
        super(code, message, cause, null, 8, null);
    }

    static {
        AUTH_FAILED = AUTH_FAILED;
        USER_FETCH_FAILED = USER_FETCH_FAILED;
        RATE_LIMIT_EXCEEDED = RATE_LIMIT_EXCEEDED;
    }

    public /* synthetic */ JBAAuthenticationException(@NotNull String code, @NotNull String message, @NotNull Throwable cause, DefaultConstructorMarker $constructor_marker) {
        this(code, message, cause);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000bJ\u0012\u0010\f\u001a\u00020\b2\n\u0010\t\u001a\u00060\rj\u0002`\u000eJ\u0012\u0010\u000f\u001a\u00020\b2\n\u0010\t\u001a\u00060\rj\u0002`\u000eJ\u0012\u0010\u0010\u001a\u00020\b2\n\u0010\t\u001a\u00060\rj\u0002`\u000eJ\u0012\u0010\u0011\u001a\u00020\b2\n\u0010\t\u001a\u00060\rj\u0002`\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ljetbrains/jetpass/auth/module/jba/dnq/client/JBAAuthenticationException$Companion;", "", "()V", "AUTH_FAILED", "", "RATE_LIMIT_EXCEEDED", "USER_FETCH_FAILED", "cantGetUser", "Ljetbrains/jetpass/auth/module/jba/dnq/client/JBAAuthenticationException;", "ex", "Ljavax/ws/rs/ProcessingException;", "Ljavax/ws/rs/WebApplicationException;", "cantParseResult", "Ljava/lang/Exception;", "Lkotlin/Exception;", "invalidRequest", "rateLimitExceeded", "requestFailed", "jetbrains.jetpass.auth.module.jba.dnq"})
    public static final class Companion {
        @NotNull
        public final JBAAuthenticationException invalidRequest(@NotNull Exception ex) {
            Intrinsics.checkParameterIsNotNull((Object)ex, (String)"ex");
            return new JBAAuthenticationException(AUTH_FAILED, "Invalid JetBrains Account request", ex, null);
        }

        @NotNull
        public final JBAAuthenticationException requestFailed(@NotNull Exception ex) {
            Intrinsics.checkParameterIsNotNull((Object)ex, (String)"ex");
            return new JBAAuthenticationException(AUTH_FAILED, "Error while requesting JetBrains Account: " + ex.getMessage(), ex, null);
        }

        @NotNull
        public final JBAAuthenticationException cantGetUser(@NotNull WebApplicationException ex) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)ex), (String)"ex");
            return new JBAAuthenticationException(USER_FETCH_FAILED, "Cannot get JetBrains Account user data: " + ex.getMessage(), ex, null);
        }

        @NotNull
        public final JBAAuthenticationException cantGetUser(@NotNull ProcessingException ex) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)ex), (String)"ex");
            return new JBAAuthenticationException(USER_FETCH_FAILED, "Cannot get JetBrains Account user data due to JBA server processing problem: " + ex.getMessage(), ex, null);
        }

        @NotNull
        public final JBAAuthenticationException rateLimitExceeded(@NotNull Exception ex) {
            Intrinsics.checkParameterIsNotNull((Object)ex, (String)"ex");
            return new JBAAuthenticationException(RATE_LIMIT_EXCEEDED, "Exceeded the limit of allowed requests per minute", ex, null);
        }

        @NotNull
        public final JBAAuthenticationException cantParseResult(@NotNull Exception ex) {
            Intrinsics.checkParameterIsNotNull((Object)ex, (String)"ex");
            return new JBAAuthenticationException(AUTH_FAILED, "Can't parse authentication result", ex, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

