/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.auth.module.jba.dnq.client;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import jetbrains.jetpass.api.authority.profile.EmailContact;
import jetbrains.jetpass.auth.module.dnq.authentication.AuthenticationException;
import jetbrains.jetpass.auth.module.jba.api.user.details.JBAUserDetailsImpl;
import jetbrains.jetpass.auth.module.jba.dnq.client.JBAAuthenticationException;
import jetbrains.jetpass.auth.module.jba.dnq.client.JBAClient;
import jetbrains.jetpass.auth.module.jba.dnq.client.JBALoginResponse;
import jetbrains.jetpass.auth.module.jba.dnq.xd.XdJBAAuthModule;
import jetbrains.jetpass.auth.module.jba.rest.client.api.JBAUserDetails;
import jetbrains.jetpass.dao.dnq.api.authority.module.JetPassAuthModuleDAO;
import jetbrains.jetpass.pojo.api.authority.profile.EmailContactImpl;
import jetbrains.jetpass.userManagement.persistence.authmodule.WebTargetCache;
import jetbrains.jetpass.userManagement.persistence.dnq.module.XdAuthModule;
import jetbrains.jetpass.userManagement.persistence.dnq.module.XdExternalAuthModule;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ$\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\fH\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ljetbrains/jetpass/auth/module/jba/dnq/client/JBAClientImpl;", "Ljetbrains/jetpass/auth/module/jba/dnq/client/JBAClient;", "xdModule", "Ljetbrains/jetpass/auth/module/jba/dnq/xd/XdJBAAuthModule;", "authModuleDAO", "Ljetbrains/jetpass/dao/dnq/api/authority/module/JetPassAuthModuleDAO;", "webTargetCache", "Ljetbrains/jetpass/userManagement/persistence/authmodule/WebTargetCache;", "(Ljetbrains/jetpass/auth/module/jba/dnq/xd/XdJBAAuthModule;Ljetbrains/jetpass/dao/dnq/api/authority/module/JetPassAuthModuleDAO;Ljetbrains/jetpass/userManagement/persistence/authmodule/WebTargetCache;)V", "requestJBA", "Ljetbrains/jetpass/auth/module/jba/rest/client/api/JBAUserDetails;", "username", "", "password", "clientServiceId", "requestUserInfo", "Ljetbrains/jetpass/auth/module/jba/dnq/client/JBALoginResponse;", "jetbrains.jetpass.auth.module.jba.dnq"})
public final class JBAClientImpl
implements JBAClient {
    private final XdJBAAuthModule xdModule;
    private final JetPassAuthModuleDAO authModuleDAO;
    private final WebTargetCache webTargetCache;

    @Override
    @Nullable
    public JBAUserDetails requestJBA(@NotNull String username, @NotNull String password, @Nullable String clientServiceId) throws AuthenticationException {
        JBAUserDetailsImpl jBAUserDetailsImpl;
        Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        JBALoginResponse jBALoginResponse = this.requestUserInfo(username, password);
        if (jBALoginResponse != null) {
            JBAUserDetailsImpl jBAUserDetailsImpl2;
            JBALoginResponse jBALoginResponse2;
            JBALoginResponse jbaUser = jBALoginResponse2 = jBALoginResponse;
            JBAUserDetailsImpl $receiver = jBAUserDetailsImpl2 = new JBAUserDetailsImpl();
            $receiver.setAuthModule(this.authModuleDAO.wrapEntity((XdAuthModule)this.xdModule));
            $receiver.setLogin(jbaUser.getLogin());
            $receiver.setFullName(jbaUser.getFullName());
            $receiver.setEmail((EmailContact)new EmailContactImpl(jbaUser.getEmail(), true));
            jBAUserDetailsImpl = jBAUserDetailsImpl2;
        } else {
            jBAUserDetailsImpl = null;
        }
        return (JBAUserDetails)jBAUserDetailsImpl;
    }

    private final JBALoginResponse requestUserInfo(String username, String password) throws AuthenticationException {
        JBALoginResponse jBALoginResponse;
        Object object;
        try {
            object = new Form();
            Invocation.Builder builder = this.webTargetCache.getOrCreate((XdExternalAuthModule)this.xdModule).path("hub-service-auth").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
            Form $receiver = object;
            $receiver.param("username", username);
            $receiver.param("password", password);
            Form form = object;
            object = (String)builder.post(Entity.form((Form)form), String.class);
        }
        catch (IllegalStateException ex) {
            throw (Throwable)((Object)JBAAuthenticationException.Companion.invalidRequest(ex));
        }
        catch (WebApplicationException e) {
            int status;
            Response response = e.getResponse();
            Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"e.response");
            int n = status = response.getStatus();
            if (n != Response.Status.UNAUTHORIZED.getStatusCode() && n != Response.Status.FORBIDDEN.getStatusCode()) {
                if (n == 429) {
                    throw (Throwable)((Object)JBAAuthenticationException.Companion.rateLimitExceeded((Exception)((Object)e)));
                }
                throw (Throwable)((Object)JBAAuthenticationException.Companion.cantGetUser(e));
            }
            return null;
        }
        catch (ProcessingException e) {
            throw (Throwable)((Object)JBAAuthenticationException.Companion.cantGetUser(e));
        }
        catch (Exception e) {
            throw (Throwable)((Object)JBAAuthenticationException.Companion.requestFailed(e));
        }
        Object json = object;
        ObjectMapper mapper = new ObjectMapper();
        try {
            jBALoginResponse = (JBALoginResponse)mapper.readValue((String)json, JBALoginResponse.class);
        }
        catch (JsonParseException ex) {
            String string = ex.getMessage();
            if (string != null) {
                if (StringsKt.contains$default((CharSequence)string, (CharSequence)"Google reCAPTCHA", (boolean)false, (int)2, null)) {
                    throw (Throwable)((Object)JBAAuthenticationException.Companion.rateLimitExceeded((Exception)((Object)ex)));
                }
            }
            throw (Throwable)((Object)JBAAuthenticationException.Companion.cantParseResult((Exception)((Object)ex)));
        }
        return jBALoginResponse;
    }

    public JBAClientImpl(@NotNull XdJBAAuthModule xdModule, @NotNull JetPassAuthModuleDAO authModuleDAO, @NotNull WebTargetCache webTargetCache) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)xdModule), (String)"xdModule");
        Intrinsics.checkParameterIsNotNull((Object)authModuleDAO, (String)"authModuleDAO");
        Intrinsics.checkParameterIsNotNull((Object)webTargetCache, (String)"webTargetCache");
        this.xdModule = xdModule;
        this.authModuleDAO = authModuleDAO;
        this.webTargetCache = webTargetCache;
    }
}

