/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.dashboard.bulkimport.exports;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.Closeable;
import java.io.File;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.StringBinding;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.PersistentEntityStore;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.StoreTransaction;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.EnvironmentConfig;
import jetbrains.exodus.env.Environments;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import jetbrains.jetpass.core.lang.CollectionsExtKt;
import jetbrains.jetpass.dashboard.bulkimport.exports.DashboardExporter;
import jetbrains.jetpass.dashboard.bulkimport.exports.olddashboard.model.Dashboard;
import jetbrains.jetpass.dashboard.bulkimport.exports.olddashboard.model.DashboardPermission;
import jetbrains.jetpass.dashboard.bulkimport.exports.olddashboard.model.PersistentEntityCollection;
import jetbrains.jetpass.dashboard.bulkimport.exports.olddashboard.model.UserDashboard;
import jetbrains.jetpass.dashboard.bulkimport.exports.olddashboard.repository.DashboardRepository;
import jetbrains.jetpass.dashboard.bulkimport.exports.olddashboard.repository.PersistentEntityRepository;
import jetbrains.jetpass.dashboard.bulkimport.imports.DashboardImportHandler;
import jetbrains.jetpass.dnq.TransactionKt;
import jetbrains.jetpass.rest.dto.DashboardImportEventJSON;
import jetbrains.jetpass.rest.dto.DashboardImportJSON;
import jetbrains.jetpass.rest.dto.DashboardImportListJSON;
import jetbrains.jetpass.rest.dto.DashboardImportMissingEntityJSON;
import jetbrains.jetpass.rest.dto.DashboardImportResultJSON;
import jetbrains.jetpass.rest.dto.DashboardPermissionImportJSON;
import jetbrains.jetpass.rest.dto.UserDashboardImportJSON;
import jetbrains.jetpass.userManagement.persistence.dnq.XdDashboardImport;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 +2\u00020\u0001:\u0002*+B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J$\u0010\u0010\u001a\u00020\u00112\b\u0010\r\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u0012\u001a\u00020\b2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0013\u001a\u00020\bH\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\fH\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0006\u0010\u001b\u001a\u00020\u0011J(\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\nH\u0002J\u001e\u0010#\u001a\u0004\u0018\u00010$*\u00020 2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\nH\u0002J\u001e\u0010&\u001a\u0004\u0018\u00010\n*\u00020 2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\nH\u0002J\f\u0010'\u001a\u00020(*\u00020)H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006,"}, d2={"Ljetbrains/jetpass/dashboard/bulkimport/exports/DashboardExporter;", "", "importHandler", "Ljetbrains/jetpass/dashboard/bulkimport/imports/DashboardImportHandler;", "(Ljetbrains/jetpass/dashboard/bulkimport/imports/DashboardImportHandler;)V", "getImportHandler", "()Ljetbrains/jetpass/dashboard/bulkimport/imports/DashboardImportHandler;", "containsXodusFiles", "", "dir", "", "exportDashboards", "Ljetbrains/jetpass/rest/dto/DashboardImportResultJSON;", "dashboardDbDir", "batchSize", "", "exportFrom", "", "forceExport", "isImportAlreadyDone", "logImportResult", "importResult", "readDashboard10Json", "", "Ljetbrains/jetpass/rest/dto/DashboardImportJSON;", "tnx", "Ljetbrains/exodus/entitystore/StoreTransaction;", "removeObsoleteServices", "transformWidgetsTo20", "store", "Ljetbrains/exodus/env/Store;", "envTransaction", "Ljetbrains/exodus/env/Transaction;", "dashboardJsonString", "ownerId", "get", "Ljetbrains/exodus/ByteIterable;", "key", "getString", "toCloseable", "Ljetbrains/jetpass/dashboard/bulkimport/exports/DashboardExporter$CloseableCursor;", "Ljetbrains/exodus/env/Cursor;", "CloseableCursor", "Companion", "jetbrains.jetpass.dashboard.bulkimport"})
public final class DashboardExporter {
    @NotNull
    private final DashboardImportHandler importHandler;
    public static final Companion Companion = new Companion(null);

    public final void exportFrom(@Nullable String dashboardDbDir, boolean forceExport, int batchSize) {
        block6: {
            try {
                if (dashboardDbDir == null) {
                    Companion.getLogger().info((Function0)exportFrom.1.INSTANCE);
                    return;
                }
                if (!this.containsXodusFiles(dashboardDbDir)) {
                    Companion.getLogger().info((Function0)new Function0<String>(dashboardDbDir){
                        final /* synthetic */ String $dashboardDbDir;

                        @NotNull
                        public final String invoke() {
                            return "Data directory " + this.$dashboardDbDir + " doesn't contain Xodus files. Skipping dashboards import.";
                        }
                        {
                            this.$dashboardDbDir = string2;
                            super(0);
                        }
                    });
                    return;
                }
                if (this.isImportAlreadyDone()) {
                    if (!forceExport) {
                        Companion.getLogger().info((Function0)exportFrom.3.INSTANCE);
                        return;
                    }
                    Companion.getLogger().info((Function0)exportFrom.4.INSTANCE);
                }
                Companion.getLogger().info((Function0)exportFrom.5.INSTANCE);
                DashboardImportResultJSON importResult = this.exportDashboards(dashboardDbDir, batchSize);
                this.logImportResult(importResult);
            }
            catch (Exception ex) {
                if (!Companion.getLogger().isErrorEnabled()) break block6;
                Companion.getLogger().error("Dashboards import failed with exception", (Throwable)ex);
            }
        }
    }

    public static /* bridge */ /* synthetic */ void exportFrom$default(DashboardExporter dashboardExporter, String string2, boolean bl, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            n = 1000;
        }
        dashboardExporter.exportFrom(string2, bl, n);
    }

    public final void removeObsoleteServices() {
        block2: {
            Companion.getLogger().info((Function0)removeObsoleteServices.1.INSTANCE);
            try {
                TransactionKt.legacyTransactional$default((boolean)false, null, (boolean)false, (Function1)removeObsoleteServices.2.INSTANCE, (int)7, null);
            }
            catch (Exception ex) {
                if (!Companion.getLogger().isErrorEnabled()) break block2;
                Companion.getLogger().error("Error removing obsolete Hub services: ", (Throwable)ex);
            }
        }
    }

    private final void logImportResult(DashboardImportResultJSON importResult) {
        if (Intrinsics.areEqual((Object)importResult.isSuccess(), (Object)true) ^ true) {
            List events;
            List missing;
            StringBuilder sb = new StringBuilder("Dashboards import failed. ");
            Iterable iterable = importResult.getMissing();
            List list = missing = iterable != null ? CollectionsKt.toList((Iterable)iterable) : null;
            if (missing != null) {
                StringBuilder stringBuilder = sb;
                String string2 = "Missing entities:";
                StringBuilder stringBuilder2 = stringBuilder.append(string2);
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder2);
                Iterable $receiver$iv = missing;
                for (StringBuilder element$iv : $receiver$iv) {
                    DashboardImportMissingEntityJSON it = (DashboardImportMissingEntityJSON)element$iv;
                    StringBuilder stringBuilder3 = sb;
                    StringBuilder stringBuilder4 = new StringBuilder().append('[');
                    DashboardImportMissingEntityJSON dashboardImportMissingEntityJSON = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)dashboardImportMissingEntityJSON, (String)"it");
                    String string3 = stringBuilder4.append(dashboardImportMissingEntityJSON.getEntityType()).append("] ").append(it.getEntityId()).toString();
                    StringBuilder stringBuilder5 = stringBuilder3.append(string3);
                    Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder5, (String)"append(value)");
                    StringsKt.appendln((StringBuilder)stringBuilder5);
                }
            }
            Iterable iterable2 = importResult.getEvents();
            List list2 = events = iterable2 != null ? CollectionsKt.toList((Iterable)iterable2) : null;
            if (events != null) {
                Object object;
                int shownCount;
                StringBuilder element$iv;
                int n = shownCount = events.size() > 100 ? 100 : events.size();
                if (shownCount == events.size()) {
                    element$iv = sb;
                    object = "Import events:";
                    StringBuilder stringBuilder = element$iv.append((String)object);
                    Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder, (String)"append(value)");
                    StringsKt.appendln((StringBuilder)stringBuilder);
                } else {
                    element$iv = sb;
                    object = "First " + shownCount + " import events (other events are skipped for brevity):";
                    StringBuilder stringBuilder = element$iv.append((String)object);
                    Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder, (String)"append(value)");
                    StringsKt.appendln((StringBuilder)stringBuilder);
                }
                Iterable $receiver$iv = CollectionsKt.take((Iterable)events, (int)shownCount);
                for (Object element$iv2 : $receiver$iv) {
                    DashboardImportEventJSON it = (DashboardImportEventJSON)element$iv2;
                    StringBuilder stringBuilder = sb;
                    StringBuilder stringBuilder6 = new StringBuilder();
                    DashboardImportEventJSON dashboardImportEventJSON = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)dashboardImportEventJSON, (String)"it");
                    String string4 = stringBuilder6.append(dashboardImportEventJSON.getSeverity()).append(" [").append(it.getPath()).append("]: ").append(it.getMessage()).toString();
                    StringBuilder stringBuilder7 = stringBuilder.append(string4);
                    Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder7, (String)"append(value)");
                    StringsKt.appendln((StringBuilder)stringBuilder7);
                }
                Companion.getLogger().error((Function0)new Function0<String>(sb){
                    final /* synthetic */ StringBuilder $sb;

                    @NotNull
                    public final String invoke() {
                        return this.$sb.toString();
                    }
                    {
                        this.$sb = stringBuilder;
                        super(0);
                    }
                });
            }
        } else {
            Companion.getLogger().info((Function0)logImportResult.4.INSTANCE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final DashboardImportResultJSON exportDashboards(String dashboardDbDir, int batchSize) {
        Iterable list$iv$iv;
        DashboardImportResultJSON it;
        Iterable $receiver$iv$iv;
        boolean bl;
        Iterable $receiver$iv;
        DashboardImportResultJSON dashboardImportResultJSON;
        DashboardImportResultJSON $receiver;
        DashboardImportResultJSON dashboardImportResultJSON2;
        void importedCount;
        List results;
        block13: {
            Environment dashboardEnv = Environments.newInstance((String)dashboardDbDir, (EnvironmentConfig)new EnvironmentConfig().setLogCachePageSize(32768));
            results = new ArrayList();
            Ref.IntRef intRef = new Ref.IntRef();
            intRef.element = 0;
            try (PersistentEntityStoreImpl dashboardStore = new PersistentEntityStoreImpl(dashboardEnv, "dashboard");){
                DashboardRepository dashboardRepository = new DashboardRepository((PersistentEntityStore)dashboardStore);
                dashboardRepository.readonly((Function2)new Function2<PersistentEntityRepository<Dashboard>, StoreTransaction, Unit>(this, batchSize, (Ref.IntRef)importedCount, results){
                    final /* synthetic */ DashboardExporter this$0;
                    final /* synthetic */ int $batchSize;
                    final /* synthetic */ Ref.IntRef $importedCount;
                    final /* synthetic */ List $results;

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull PersistentEntityRepository<Dashboard> $receiver, @NotNull StoreTransaction tnx) {
                        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                        Intrinsics.checkParameterIsNotNull((Object)tnx, (String)"tnx");
                        Sequence $receiver$iv = CollectionsExtKt.chunked((Sequence)CollectionsKt.asSequence((Iterable)$receiver.all(tnx)), (int)this.$batchSize);
                        for (E element$iv : $receiver$iv) {
                            Iterable iterable;
                            Object object;
                            void $receiver$iv$iv;
                            Iterable $receiver$iv2;
                            List chunk = (List)element$iv;
                            DashboardExporter.Companion.getLogger().debug((Function0)new Function0<String>(chunk, this){
                                final /* synthetic */ List $chunk;
                                final /* synthetic */ exportDashboards.1 this$0;
                                {
                                    this.$chunk = list;
                                    this.this$0 = var2_2;
                                    super(0);
                                }

                                @NotNull
                                public final String invoke() {
                                    return "Start iteration [" + this.this$0.$importedCount.element + ", " + (this.this$0.$importedCount.element + this.$chunk.size()) + ']';
                                }
                            });
                            Iterable iterable2 = $receiver$iv2 = (Iterable)chunk;
                            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                            for (T item$iv$iv : $receiver$iv$iv) {
                                DashboardPermissionImportJSON dashboardPermissionImportJSON;
                                UserDashboard p;
                                DashboardPermissionImportJSON $receiver2;
                                DashboardPermissionImportJSON dashboardPermissionImportJSON2;
                                Collection<DashboardPermissionImportJSON> collection;
                                Iterable $receiver$iv$iv2;
                                Iterable $receiver$iv3;
                                DashboardImportJSON dashboardImportJSON;
                                void dashboard;
                                Dashboard dashboard2 = (Dashboard)item$iv$iv;
                                object = destination$iv$iv;
                                PersistentEntityCollection<DashboardPermission> permissions = dashboard.getPermissions();
                                PersistentEntityCollection<UserDashboard> userDashboards = dashboard.getUserDashboards();
                                DashboardImportJSON $receiver3 = dashboardImportJSON = new DashboardImportJSON();
                                $receiver3.setId(dashboard.getUuid());
                                $receiver3.setName(dashboard.getName());
                                $receiver3.setOwner(dashboard.getOwner());
                                $receiver3.setJson(dashboard.getJson());
                                Iterable iterable3 = permissions;
                                DashboardImportJSON dashboardImportJSON2 = $receiver3;
                                void var20_20 = $receiver$iv3;
                                Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
                                for (T item$iv$iv2 : $receiver$iv$iv2) {
                                    DashboardPermission dashboardPermission = (DashboardPermission)item$iv$iv2;
                                    collection = destination$iv$iv2;
                                    $receiver2 = dashboardPermissionImportJSON2 = new DashboardPermissionImportJSON();
                                    $receiver2.setId(p.getUuid());
                                    $receiver2.setPrincipal(((DashboardPermission)((Object)p)).getPrincipal());
                                    $receiver2.setType(((DashboardPermission)((Object)p)).getType().toString());
                                    $receiver2.setPermission(((DashboardPermission)((Object)p)).getPermission().toString());
                                    dashboardPermissionImportJSON = dashboardPermissionImportJSON2;
                                    collection.add(dashboardPermissionImportJSON);
                                }
                                collection = (List)destination$iv$iv2;
                                dashboardImportJSON2.setPermissions((Iterable)collection);
                                $receiver$iv3 = userDashboards;
                                dashboardImportJSON2 = $receiver3;
                                $receiver$iv$iv2 = $receiver$iv3;
                                destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
                                for (T item$iv$iv2 : $receiver$iv$iv2) {
                                    void ud;
                                    p = (UserDashboard)item$iv$iv2;
                                    collection = destination$iv$iv2;
                                    $receiver2 = dashboardPermissionImportJSON2 = new UserDashboardImportJSON();
                                    $receiver2.setId(ud.getUuid());
                                    $receiver2.setUser(ud.getUser());
                                    $receiver2.setOrdinal(Integer.valueOf(ud.getOrdinal()));
                                    $receiver2.setFavorite(Boolean.valueOf(ud.getFavorite()));
                                    dashboardPermissionImportJSON = dashboardPermissionImportJSON2;
                                    collection.add(dashboardPermissionImportJSON);
                                }
                                collection = (List)destination$iv$iv2;
                                dashboardImportJSON2.setUserDashboards((Iterable)collection);
                                iterable = dashboardImportJSON;
                                object.add(iterable);
                            }
                            List jsonDashboards = (List)destination$iv$iv;
                            DashboardExporter.Companion.getLogger().debug((Function0)new Function0<String>(chunk){
                                final /* synthetic */ List $chunk;

                                @NotNull
                                public final String invoke() {
                                    return "Have read " + this.$chunk.size() + " source records and transformed it to JSON";
                                }
                                {
                                    this.$chunk = list;
                                    super(0);
                                }
                            });
                            iterable2 = new DashboardImportListJSON();
                            object = this.this$0.getImportHandler();
                            Iterable $receiver4 = iterable2;
                            $receiver4.setItems(jsonDashboards);
                            iterable = iterable2;
                            DashboardImportResultJSON importResult = object.import((DashboardImportListJSON)iterable, this.$batchSize);
                            this.$results.add(importResult);
                            DashboardExporter.Companion.getLogger().info((Function0)new Function0<String>(chunk, importResult, this){
                                final /* synthetic */ List $chunk;
                                final /* synthetic */ DashboardImportResultJSON $importResult;
                                final /* synthetic */ exportDashboards.1 this$0;
                                {
                                    this.$chunk = list;
                                    this.$importResult = dashboardImportResultJSON;
                                    this.this$0 = var3_3;
                                    super(0);
                                }

                                @NotNull
                                public final String invoke() {
                                    return "Intermediate result from " + this.this$0.$importedCount.element + " to " + (this.this$0.$importedCount.element + this.$chunk.size()) + " is " + (Intrinsics.areEqual((Object)this.$importResult.isSuccess(), (Object)true) ? "success" : "fail");
                                }
                            });
                            this.$importedCount.element += chunk.size();
                        }
                        if (this.$importedCount.element == 0) {
                            DashboardExporter.Companion.getLogger().info((Function0)exportDashboards.2.INSTANCE);
                            List dashboards10Json = DashboardExporter.access$readDashboard10Json(this.this$0, tnx);
                            DashboardExporter.Companion.getLogger().info((Function0)new Function0<String>(dashboards10Json){
                                final /* synthetic */ List $dashboards10Json;

                                @NotNull
                                public final String invoke() {
                                    return "Found " + this.$dashboards10Json.size() + " dashboards in old format";
                                }
                                {
                                    this.$dashboards10Json = list;
                                    super(0);
                                }
                            });
                            DashboardImportListJSON dashboardImportListJSON = new DashboardImportListJSON();
                            DashboardImportHandler dashboardImportHandler = this.this$0.getImportHandler();
                            DashboardImportListJSON $receiver5 = dashboardImportListJSON;
                            $receiver5.setItems((Iterable)dashboards10Json);
                            DashboardImportListJSON dashboardImportListJSON2 = dashboardImportListJSON;
                            DashboardImportResultJSON importResult = dashboardImportHandler.import(dashboardImportListJSON2, this.$batchSize);
                            this.$results.add(importResult);
                            DashboardExporter.Companion.getLogger().info((Function0)new Function0<String>(importResult){
                                final /* synthetic */ DashboardImportResultJSON $importResult;

                                @NotNull
                                public final String invoke() {
                                    return "Import of old formatted dashboards: " + (Intrinsics.areEqual((Object)this.$importResult.isSuccess(), (Object)true) ? "success" : "fail");
                                }
                                {
                                    this.$importResult = dashboardImportResultJSON;
                                    super(0);
                                }
                            });
                            this.$importedCount.element += dashboards10Json.size();
                        }
                    }
                    {
                        this.this$0 = dashboardExporter;
                        this.$batchSize = n;
                        this.$importedCount = intRef;
                        this.$results = list;
                        super(2);
                    }
                });
            }
            $receiver = dashboardImportResultJSON2 = new DashboardImportResultJSON();
            Iterable iterable = results;
            dashboardImportResultJSON = $receiver;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    DashboardImportResultJSON it2 = (DashboardImportResultJSON)element$iv;
                    if (Intrinsics.areEqual((Object)it2.isSuccess(), (Object)true)) continue;
                    bl = false;
                    break block13;
                }
                bl = true;
            }
        }
        boolean bl2 = bl;
        dashboardImportResultJSON.setSuccess(Boolean.valueOf(bl2));
        $receiver$iv = results;
        dashboardImportResultJSON = $receiver;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (DashboardImportResultJSON)element$iv$iv;
            if (!(it.getEvents() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv = (Iterable)list;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (DashboardImportResultJSON)element$iv$iv;
            if (it.getEvents() == null) {
                Intrinsics.throwNpe();
            }
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        list = (List)destination$iv$iv;
        dashboardImportResultJSON.setEvents((Iterable)list);
        $receiver$iv = results;
        dashboardImportResultJSON = $receiver;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (DashboardImportResultJSON)element$iv$iv;
            if (!(it.getMissing() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        list = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv = (Iterable)list;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (DashboardImportResultJSON)element$iv$iv;
            if (it.getMissing() == null) {
                Intrinsics.throwNpe();
            }
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        list = (List)destination$iv$iv;
        dashboardImportResultJSON.setMissing((Iterable)list);
        DashboardImportResultJSON exportResult = dashboardImportResultJSON2;
        TransactionKt.legacyTransactional$default((boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, XdDashboardImport>(exportResult){
            final /* synthetic */ DashboardImportResultJSON $exportResult;

            @NotNull
            public final XdDashboardImport invoke(@NotNull TransientStoreSession it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return XdDashboardImport.Companion.new(Intrinsics.areEqual((Object)this.$exportResult.isSuccess(), (Object)true));
            }
            {
                this.$exportResult = dashboardImportResultJSON;
                super(1);
            }
        }), (int)7, null);
        Companion.getLogger().info((Function0)new Function0<String>((Ref.IntRef)importedCount){
            final /* synthetic */ Ref.IntRef $importedCount;

            @NotNull
            public final String invoke() {
                return "Processed " + this.$importedCount.element + " dashboards.";
            }
            {
                this.$importedCount = intRef;
                super(0);
            }
        });
        return exportResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final List<DashboardImportJSON> readDashboard10Json(StoreTransaction tnx) {
        Transaction envTransaction;
        StoreTransaction storeTransaction = tnx;
        if (storeTransaction == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.exodus.entitystore.PersistentStoreTransaction");
        }
        Transaction transaction2 = envTransaction = ((PersistentStoreTransaction)storeTransaction).getEnvironmentTransaction();
        Intrinsics.checkExpressionValueIsNotNull((Object)transaction2, (String)"envTransaction");
        Store store = transaction2.getEnvironment().openStore("data", StoreConfig.WITHOUT_DUPLICATES, envTransaction);
        List jsonDashboards = new ArrayList();
        Cursor cursor = store.openCursor(envTransaction);
        Intrinsics.checkExpressionValueIsNotNull((Object)cursor, (String)"store.openCursor(envTransaction)");
        Closeable closeable = this.toCloseable(cursor);
        Throwable throwable = null;
        try {
            CloseableCursor it = (CloseableCursor)closeable;
            while (it.getNext()) {
                void userId;
                DashboardImportJSON dashboardImportJSON;
                List list;
                String entryKey;
                String string2 = entryKey = StringBinding.entryToString((ByteIterable)it.getKey());
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"entryKey");
                List list2 = list = StringsKt.split$default((CharSequence)string2, (String[])new String[]{"@"}, (boolean)false, (int)0, (int)6, null);
                String string3 = (String)list2.get(0);
                list2 = list;
                String key = (String)list2.get(1);
                if (!Intrinsics.areEqual((Object)key, (Object)"myDashboard5")) continue;
                String data = StringBinding.entryToString((ByteIterable)it.getValue());
                DashboardImportJSON $receiver = dashboardImportJSON = new DashboardImportJSON();
                $receiver.setName(DashboardImportHandler.Companion.getDEFAULT_GUESTS_DASHBOARD_NAME_25());
                $receiver.setOwner((String)userId);
                Store store2 = store;
                Intrinsics.checkExpressionValueIsNotNull((Object)store2, (String)"store");
                String string4 = data;
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"data");
                $receiver.setJson(this.transformWidgetsTo20(store2, envTransaction, string4, (String)userId));
                UserDashboardImportJSON userDashboardImportJSON = new UserDashboardImportJSON();
                DashboardImportJSON dashboardImportJSON2 = $receiver;
                UserDashboardImportJSON $receiver2 = userDashboardImportJSON;
                $receiver2.setUser((String)userId);
                UserDashboardImportJSON userDashboardImportJSON2 = userDashboardImportJSON;
                dashboardImportJSON2.setUserDashboards((Iterable)CollectionsKt.listOf((Object)userDashboardImportJSON2));
                DashboardImportJSON dashboardJson = dashboardImportJSON;
                jsonDashboards.add(dashboardJson);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return jsonDashboards;
    }

    private final String transformWidgetsTo20(Store store, Transaction envTransaction, String dashboardJsonString, String ownerId) {
        DocumentContext json = JsonPath.parse((String)dashboardJsonString);
        try {
            Integer widgetsCount;
            Integer n = widgetsCount = (Integer)json.read("$.widgets.length()", new Predicate[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"widgetsCount");
            Iterable $receiver$iv = (Iterable)RangesKt.until((int)0, (int)n);
            Iterator iterator2 = $receiver$iv.iterator();
            while (iterator2.hasNext()) {
                int element$iv;
                int i = element$iv = ((IntIterator)iterator2).nextInt();
                try {
                    String id = (String)json.read("$.widgets[" + i + "].config.id", new Predicate[0]);
                    String data = this.getString(envTransaction, store, ownerId + "@widgetMarkdown:" + id);
                    if (data == null) continue;
                    String text = (String)JsonPath.read((String)data, (String)"$.text", (Predicate[])new Predicate[0]);
                    json.put("$.widgets[" + i + "].config", "message", (Object)text, new Predicate[0]);
                }
                catch (InvalidPathException invalidPathException) {
                }
            }
            String string2 = json.jsonString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"json.jsonString()");
            return string2;
        }
        catch (InvalidPathException invalidPathException) {
            return dashboardJsonString;
        }
    }

    private final ByteIterable get(@NotNull Transaction $receiver, Store store, String key) {
        return store.get($receiver, (ByteIterable)StringBinding.stringToEntry((String)key));
    }

    private final String getString(@NotNull Transaction $receiver, Store store, String key) {
        String string2;
        ByteIterable byteIterable = this.get($receiver, store, key);
        if (byteIterable != null) {
            ByteIterable byteIterable2;
            ByteIterable it = byteIterable2 = byteIterable;
            string2 = StringBinding.entryToString((ByteIterable)it);
        } else {
            string2 = null;
        }
        return string2;
    }

    private final CloseableCursor toCloseable(@NotNull Cursor $receiver) {
        return new CloseableCursor($receiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean containsXodusFiles(String dir) {
        File directory = new File(dir);
        if (directory.exists()) {
            Closeable closeable = Files.newDirectoryStream(directory.toPath());
            Throwable throwable = null;
            try {
                boolean bl;
                block10: {
                    DirectoryStream dirStream;
                    DirectoryStream directoryStream = dirStream = (DirectoryStream)closeable;
                    Intrinsics.checkExpressionValueIsNotNull((Object)directoryStream, (String)"dirStream");
                    Iterable $receiver$iv = directoryStream;
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $receiver$iv) {
                            String string2;
                            Path path = (Path)element$iv;
                            String string3 = string2 = ((Object)path).toString();
                            if (string3 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                            }
                            String string4 = string3.toLowerCase();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
                            if (!StringsKt.endsWith$default((String)string4, (String)".xd", (boolean)false, (int)2, null)) continue;
                            bl = true;
                            break block10;
                        }
                        bl = false;
                    }
                }
                boolean bl2 = bl;
                return bl2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return false;
    }

    private final boolean isImportAlreadyDone() {
        boolean bl;
        try {
            bl = (Boolean)TransactionKt.legacyTransactional$default((boolean)false, null, (boolean)false, (Function1)isImportAlreadyDone.alreadyDone.1.INSTANCE, (int)7, null);
        }
        catch (Exception e) {
            Companion.getLogger().error("Can't get information about the last dashboards import", (Throwable)e);
            return true;
        }
        boolean alreadyDone2 = bl;
        return alreadyDone2;
    }

    @NotNull
    public final DashboardImportHandler getImportHandler() {
        return this.importHandler;
    }

    public DashboardExporter(@NotNull DashboardImportHandler importHandler) {
        Intrinsics.checkParameterIsNotNull((Object)importHandler, (String)"importHandler");
        this.importHandler = importHandler;
    }

    @NotNull
    public static final /* synthetic */ List access$readDashboard10Json(DashboardExporter $this, @NotNull StoreTransaction tnx) {
        return $this.readDashboard10Json(tnx);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\t\u0010\u0007\u001a\u00020\bH\u0096\u0001J\t\u0010\t\u001a\u00020\nH\u0096\u0001J\t\u0010\u000b\u001a\u00020\fH\u0097\u0001J\t\u0010\r\u001a\u00020\nH\u0096\u0001J\t\u0010\u000e\u001a\u00020\nH\u0096\u0001J\t\u0010\u000f\u001a\u00020\nH\u0096\u0001J\t\u0010\u0010\u001a\u00020\nH\u0096\u0001J\t\u0010\u0011\u001a\u00020\nH\u0096\u0001J\t\u0010\u0012\u001a\u00020\nH\u0096\u0001J\t\u0010\u0013\u001a\u00020\nH\u0096\u0001J\u001d\u0010\u0014\u001a\u00020\n2\b\b\u0001\u0010\u0015\u001a\u00020\f2\b\b\u0001\u0010\u0016\u001a\u00020\fH\u0096\u0001J\u001f\u0010\u0017\u001a\u0004\u0018\u00010\f2\b\b\u0001\u0010\u0015\u001a\u00020\f2\b\b\u0001\u0010\u0016\u001a\u00020\fH\u0097\u0001J\u0015\u0010\u0018\u001a\u0004\u0018\u00010\f2\b\b\u0001\u0010\u0015\u001a\u00020\fH\u0097\u0001J\u0015\u0010\u0019\u001a\u0004\u0018\u00010\f2\b\b\u0001\u0010\u0015\u001a\u00020\fH\u0097\u0001J\t\u0010\u001a\u001a\u00020\fH\u0097\u0001J\t\u0010\u001b\u001a\u00020\nH\u0096\u0001R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Ljetbrains/jetpass/dashboard/bulkimport/exports/DashboardExporter$CloseableCursor;", "Ljetbrains/exodus/env/Cursor;", "Ljava/io/Closeable;", "resource", "(Ljetbrains/exodus/env/Cursor;)V", "close", "", "count", "", "deleteCurrent", "", "getKey", "Ljetbrains/exodus/ByteIterable;", "getLast", "getNext", "getNextDup", "getNextNoDup", "getPrev", "getPrevDup", "getPrevNoDup", "getSearchBoth", "p0", "p1", "getSearchBothRange", "getSearchKey", "getSearchKeyRange", "getValue", "isMutable", "jetbrains.jetpass.dashboard.bulkimport"})
    private static final class CloseableCursor
    implements Cursor,
    Closeable {
        private final Cursor resource;

        @Override
        public void close() {
            this.resource.close();
        }

        public CloseableCursor(@NotNull Cursor resource) {
            Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
            this.resource = resource;
        }

        public int count() {
            return this.resource.count();
        }

        public boolean deleteCurrent() {
            return this.resource.deleteCurrent();
        }

        @NotNull
        public ByteIterable getKey() {
            return this.resource.getKey();
        }

        public boolean getLast() {
            return this.resource.getLast();
        }

        public boolean getNext() {
            return this.resource.getNext();
        }

        public boolean getNextDup() {
            return this.resource.getNextDup();
        }

        public boolean getNextNoDup() {
            return this.resource.getNextNoDup();
        }

        public boolean getPrev() {
            return this.resource.getPrev();
        }

        public boolean getPrevDup() {
            return this.resource.getPrevDup();
        }

        public boolean getPrevNoDup() {
            return this.resource.getPrevNoDup();
        }

        public boolean getSearchBoth(@NotNull ByteIterable p0, @NotNull ByteIterable p1) {
            Intrinsics.checkParameterIsNotNull((Object)p0, (String)"p0");
            Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
            return this.resource.getSearchBoth(p0, p1);
        }

        @Nullable
        public ByteIterable getSearchBothRange(@NotNull ByteIterable p0, @NotNull ByteIterable p1) {
            Intrinsics.checkParameterIsNotNull((Object)p0, (String)"p0");
            Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
            return this.resource.getSearchBothRange(p0, p1);
        }

        @Nullable
        public ByteIterable getSearchKey(@NotNull ByteIterable p0) {
            Intrinsics.checkParameterIsNotNull((Object)p0, (String)"p0");
            return this.resource.getSearchKey(p0);
        }

        @Nullable
        public ByteIterable getSearchKeyRange(@NotNull ByteIterable p0) {
            Intrinsics.checkParameterIsNotNull((Object)p0, (String)"p0");
            return this.resource.getSearchKeyRange(p0);
        }

        @NotNull
        public ByteIterable getValue() {
            return this.resource.getValue();
        }

        public boolean isMutable() {
            return this.resource.isMutable();
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/jetpass/dashboard/bulkimport/exports/DashboardExporter$Companion;", "Lmu/KLogging;", "()V", "jetbrains.jetpass.dashboard.bulkimport"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

