/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.dashboard.bulkimport.imports;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.query.NodeBase;
import jetbrains.jetpass.core.lang.CollectionsExtKt;
import jetbrains.jetpass.dashboard.bulkimport.Permission;
import jetbrains.jetpass.dashboard.bulkimport.imports.DashboardImportHandler;
import jetbrains.jetpass.dashboard.bulkimport.imports.DashboardImportHandlerImpl$BatchHandler$handle$;
import jetbrains.jetpass.dashboard.bulkimport.imports.DashboardImportHandlerImpl$BatchHandler$removeGuestsDefaultDashboardIfExists$existingDashboards$1;
import jetbrains.jetpass.dashboard.bulkimport.utils.MeasuresKt;
import jetbrains.jetpass.dnq.TransactionKt;
import jetbrains.jetpass.rest.dto.DashboardImportEventJSON;
import jetbrains.jetpass.rest.dto.DashboardImportJSON;
import jetbrains.jetpass.rest.dto.DashboardImportListJSON;
import jetbrains.jetpass.rest.dto.DashboardImportMissingEntityJSON;
import jetbrains.jetpass.rest.dto.DashboardImportResultJSON;
import jetbrains.jetpass.rest.dto.DashboardPermissionImportJSON;
import jetbrains.jetpass.rest.dto.UserDashboardImportJSON;
import jetbrains.jetpass.userManagement.persistence.dnq.XdAuthorityHolder;
import jetbrains.jetpass.userManagement.persistence.dnq.XdBaseUser;
import jetbrains.jetpass.userManagement.persistence.dnq.XdDashboard;
import jetbrains.jetpass.userManagement.persistence.dnq.XdDashboardPermission;
import jetbrains.jetpass.userManagement.persistence.dnq.XdGuestUser;
import jetbrains.jetpass.userManagement.persistence.dnq.XdMergeAction;
import jetbrains.jetpass.userManagement.persistence.dnq.XdUUIDObject;
import jetbrains.jetpass.userManagement.persistence.dnq.XdUUIDObjectNaturalEntityType;
import jetbrains.jetpass.userManagement.persistence.dnq.XdUserDashboard;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.query.NodeBaseOperationsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \n2\u00020\u0001:\u0002\t\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Ljetbrains/jetpass/dashboard/bulkimport/imports/DashboardImportHandlerImpl;", "Ljetbrains/jetpass/dashboard/bulkimport/imports/DashboardImportHandler;", "()V", "import", "Ljetbrains/jetpass/rest/dto/DashboardImportResultJSON;", "dashboardList", "Ljetbrains/jetpass/rest/dto/DashboardImportListJSON;", "batchSize", "", "BatchHandler", "Companion", "jetbrains.jetpass.dashboard.bulkimport"})
public final class DashboardImportHandlerImpl
implements DashboardImportHandler {
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public DashboardImportResultJSON import(@NotNull DashboardImportListJSON dashboardList, int batchSize) {
        DashboardImportResultJSON dashboardImportResultJSON;
        Intrinsics.checkParameterIsNotNull((Object)dashboardList, (String)"dashboardList");
        UUID importId = UUID.randomUUID();
        Companion.getLogger().debug((Function0)new Function0<String>(importId){
            final /* synthetic */ UUID $importId;

            @NotNull
            public final String invoke() {
                return "Dashboards import [" + this.$importId + "] has started";
            }
            {
                this.$importId = uUID;
                super(0);
            }
        });
        try {
            dashboardImportResultJSON = new BatchHandler(batchSize).handle(dashboardList);
        }
        catch (Exception ex) {
            if (Companion.getLogger().isErrorEnabled()) {
                Companion.getLogger().error("Dashboards import [" + importId + "] failed with error", (Throwable)ex);
            }
            throw (Throwable)ex;
        }
        DashboardImportResultJSON result = dashboardImportResultJSON;
        Companion.getLogger().debug((Function0)new Function0<String>(importId, result){
            final /* synthetic */ UUID $importId;
            final /* synthetic */ DashboardImportResultJSON $result;

            @NotNull
            public final String invoke() {
                return "Dashboards import [" + this.$importId + "] has finished with " + (Intrinsics.areEqual((Object)this.$result.isSuccess(), (Object)true) ? "success" : "failure");
            }
            {
                this.$importId = uUID;
                this.$result = dashboardImportResultJSON;
                super(0);
            }
        });
        return result;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\nH\u0002J \u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\nH\u0002J\u0018\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\nH\u0002J\u001a\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0013\u001a\u00020\nH\u0002J&\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\nH\u0002J&\u0010\"\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u001f2\u0006\u0010!\u001a\u00020\nH\u0002J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(J\u001a\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\nH\u0002J\u0010\u0010,\u001a\u00020\u00112\u0006\u0010-\u001a\u00020.H\u0002J\u0018\u0010/\u001a\u00020\u00112\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0003H\u0002J)\u00103\u001a\u0004\u0018\u0001H4\"\b\b\u0000\u00104*\u00020\u000f*\b\u0012\u0004\u0012\u0002H4052\u0006\u00106\u001a\u00020\n\u00a2\u0006\u0002\u00107J3\u00108\u001a\u0004\u0018\u0001H4\"\b\b\u0000\u00104*\u00020\u000f*\b\u0012\u0004\u0012\u0002H4052\u0006\u00106\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u00109R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Ljetbrains/jetpass/dashboard/bulkimport/imports/DashboardImportHandlerImpl$BatchHandler;", "", "batchSize", "", "(I)V", "importEvents", "", "Ljetbrains/jetpass/rest/dto/DashboardImportEventJSON;", "notFoundEntities", "", "", "", "severityError", "severityWarn", "uuidSearchCache", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdUUIDObject;", "addError", "", "message", "path", "addNotFoundError", "entityType", "id", "addWarn", "checkNotEmpty", "", "value", "createPermissions", "dashboard", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdDashboard;", "permissionsData", "", "Ljetbrains/jetpass/rest/dto/DashboardPermissionImportJSON;", "dashboardPath", "createUserDashboards", "userDashboardData", "Ljetbrains/jetpass/rest/dto/UserDashboardImportJSON;", "handle", "Ljetbrains/jetpass/rest/dto/DashboardImportResultJSON;", "dashboardList", "Ljetbrains/jetpass/rest/dto/DashboardImportListJSON;", "parsePermission", "Ljetbrains/jetpass/dashboard/bulkimport/Permission;", "permission", "removeGuestsDefaultDashboardIfExists", "guest", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdBaseUser;", "saveDashboard", "dashboardData", "Ljetbrains/jetpass/rest/dto/DashboardImportJSON;", "dashboardIdx", "findByUuid", "T", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdUUIDObjectNaturalEntityType;", "uuid", "(Ljetbrains/jetpass/userManagement/persistence/dnq/XdUUIDObjectNaturalEntityType;Ljava/lang/String;)Ljetbrains/jetpass/userManagement/persistence/dnq/XdUUIDObject;", "tryFindByUuid", "(Ljetbrains/jetpass/userManagement/persistence/dnq/XdUUIDObjectNaturalEntityType;Ljava/lang/String;Ljava/lang/String;)Ljetbrains/jetpass/userManagement/persistence/dnq/XdUUIDObject;", "jetbrains.jetpass.dashboard.bulkimport"})
    private static final class BatchHandler {
        private final String severityError = "error";
        private final String severityWarn = "warn";
        private final List<DashboardImportEventJSON> importEvents;
        private final Map<String, Set<String>> notFoundEntities;
        private final Map<String, XdUUIDObject> uuidSearchCache;
        private final int batchSize;

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final DashboardImportResultJSON handle(@NotNull DashboardImportListJSON dashboardList) {
            Map<String, Set<String>> $receiver$iv$iv;
            Map<String, Set<String>> $receiver$iv;
            DashboardImportResultJSON dashboardImportResultJSON;
            Iterable<Object> element$iv2;
            Intrinsics.checkParameterIsNotNull((Object)dashboardList, (String)"dashboardList");
            Iterable items = dashboardList.getItems();
            if (items != null) {
                Sequence $receiver$iv2 = CollectionsExtKt.chunked((Sequence)CollectionsKt.asSequence((Iterable)items), (int)this.batchSize);
                for (Iterable<Object> element$iv2 : $receiver$iv2) {
                    List chunk = (List)element$iv2;
                    MeasuresKt.measureAction("Saving a batch of " + chunk.size() + " records", (Function0<Unit>)((Function0)new Function0<Unit>(chunk, this){
                        final /* synthetic */ List $chunk;
                        final /* synthetic */ BatchHandler this$0;
                        {
                            this.$chunk = list;
                            this.this$0 = batchHandler;
                            super(0);
                        }

                        public final void invoke() {
                            TransactionKt.legacyTransactional$default((boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, Unit>(this){
                                final /* synthetic */ BatchHandler$handle$$inlined$forEach$lambda$1 this$0;
                                {
                                    this.this$0 = var1_1;
                                    super(1);
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                public final void invoke(@NotNull TransientStoreSession it) {
                                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                    BatchHandler.access$getUuidSearchCache$p(this.this$0.this$0).clear();
                                    Iterable $receiver$iv = this.this$0.$chunk;
                                    int index$iv = 0;
                                    for (T item$iv : $receiver$iv) {
                                        void it2;
                                        int n;
                                        if ((n = index$iv++) < 0) {
                                            throw (Throwable)new ArithmeticException("Index overflow has happened.");
                                        }
                                        int n2 = n;
                                        DashboardImportJSON dashboardImportJSON = (DashboardImportJSON)item$iv;
                                        int idx = n2;
                                        BatchHandler batchHandler = this.this$0.this$0;
                                        void v1 = it2;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                                        BatchHandler.access$saveDashboard(batchHandler, (DashboardImportJSON)v1, idx);
                                    }
                                }
                            }), (int)7, null);
                        }
                    }));
                }
            }
            DashboardImportResultJSON $receiver = dashboardImportResultJSON = new DashboardImportResultJSON();
            element$iv2 = this.importEvents;
            DashboardImportResultJSON dashboardImportResultJSON2 = $receiver;
            void $i$a$1$forEach = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            Object object = $receiver$iv$iv.iterator();
            while (object.hasNext()) {
                Object element$iv$iv = object.next();
                DashboardImportEventJSON it = (DashboardImportEventJSON)element$iv$iv;
                if (!this.severityError.equals(it.getSeverity())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            dashboardImportResultJSON2.setSuccess(Boolean.valueOf(list.isEmpty()));
            $receiver$iv = this.importEvents;
            if (!$receiver$iv.isEmpty()) {
                $receiver.setEvents((Iterable)this.importEvents);
            }
            if (!($receiver$iv = this.notFoundEntities).isEmpty()) {
                $receiver$iv = this.notFoundEntities;
                dashboardImportResultJSON2 = $receiver;
                $receiver$iv$iv = $receiver$iv;
                destination$iv$iv = new ArrayList();
                object = $receiver$iv$iv;
                Iterator iterator2 = object.entrySet().iterator();
                while (iterator2.hasNext()) {
                    void $receiver$iv$iv2;
                    Iterable $receiver$iv3;
                    Map.Entry element$iv$iv;
                    Map.Entry item = element$iv$iv = iterator2.next();
                    Iterable $i$f$filter = $receiver$iv3 = (Iterable)item.getValue();
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
                    for (Object item$iv$iv : $receiver$iv$iv2) {
                        void it;
                        DashboardImportMissingEntityJSON dashboardImportMissingEntityJSON;
                        String string2 = (String)item$iv$iv;
                        Collection collection = destination$iv$iv2;
                        DashboardImportMissingEntityJSON $receiver2 = dashboardImportMissingEntityJSON = new DashboardImportMissingEntityJSON();
                        $receiver2.setEntityType((String)item.getKey());
                        $receiver2.setEntityId((String)it);
                        DashboardImportMissingEntityJSON dashboardImportMissingEntityJSON2 = dashboardImportMissingEntityJSON;
                        collection.add(dashboardImportMissingEntityJSON2);
                    }
                    Iterable list$iv$iv = (List)destination$iv$iv2;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                list = (List)destination$iv$iv;
                dashboardImportResultJSON2.setMissing((Iterable)list);
            }
            return dashboardImportResultJSON;
        }

        private final void saveDashboard(DashboardImportJSON dashboardData, int dashboardIdx) {
            Iterable userDashboardData;
            Iterable permissionsData;
            XdDashboard existingDashboard;
            String dashboardPath = "$.items[" + dashboardIdx + ']';
            String dashboardId = dashboardData.getId();
            XdDashboard xdDashboard = existingDashboard = dashboardId != null ? (XdDashboard)XdDashboard.Companion.resolve(dashboardId) : null;
            if (existingDashboard != null) {
                this.addWarn("Dashboard already exists", dashboardPath);
                return;
            }
            if (!this.checkNotEmpty(dashboardData.getOwner(), dashboardPath + ".owner")) {
                return;
            }
            if (!this.checkNotEmpty(dashboardData.getJson(), dashboardPath + ".json")) {
                return;
            }
            XdUUIDObjectNaturalEntityType xdUUIDObjectNaturalEntityType = (XdUUIDObjectNaturalEntityType)XdBaseUser.Companion;
            String string2 = dashboardData.getOwner();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"dashboardData.owner!!");
            XdBaseUser xdBaseUser = (XdBaseUser)this.tryFindByUuid(xdUUIDObjectNaturalEntityType, string2, dashboardPath + ".owner");
            if (xdBaseUser == null) {
                return;
            }
            XdBaseUser ownerUser = xdBaseUser;
            CharSequence charSequence = dashboardData.getName();
            if (charSequence == null || charSequence.length() == 0) {
                dashboardData.setName(ownerUser.getLogin() + "'s dashboard");
            }
            if (ownerUser instanceof XdGuestUser) {
                this.removeGuestsDefaultDashboardIfExists(ownerUser);
                dashboardData.setName(DashboardImportHandler.Companion.getDEFAULT_GUESTS_DASHBOARD_NAME_25());
            }
            XdDashboard dashboard = XdDashboard.Companion.new(dashboardData.getName(), ownerUser, dashboardData.getJson());
            if (dashboardId != null) {
                dashboard.setUuid(dashboardId);
            }
            if ((permissionsData = dashboardData.getPermissions()) != null) {
                this.createPermissions(dashboard, permissionsData, dashboardPath);
            }
            if ((userDashboardData = dashboardData.getUserDashboards()) != null) {
                this.createUserDashboards(dashboard, userDashboardData, dashboardPath);
            }
        }

        private final void removeGuestsDefaultDashboardIfExists(XdBaseUser guest) {
            Iterable $receiver$iv;
            KProperty1 kProperty1 = (KProperty1)DashboardImportHandlerImpl$BatchHandler$removeGuestsDefaultDashboardIfExists$existingDashboards$1.INSTANCE;
            XdQuery xdQuery = XdDashboard.Companion.all();
            NodeBase nodeBase = NodeBaseOperationsKt.eq((KProperty1)$receiver$iv, (KClass)Reflection.getOrCreateKotlinClass(XdDashboard.class), (XdEntity)((XdEntity)guest));
            List existingDashboards2 = SequencesKt.toList((Sequence)XdQueryKt.asSequence((XdQuery)XdQueryKt.query((XdQuery)xdQuery, (NodeBase)nodeBase)));
            $receiver$iv = existingDashboards2;
            for (Object element$iv : $receiver$iv) {
                XdDashboard it = (XdDashboard)element$iv;
                it.delete(null, XdMergeAction.Companion.getDELETE());
            }
        }

        private final void addError(String message, String path) {
            DashboardImportEventJSON dashboardImportEventJSON = new DashboardImportEventJSON();
            List<DashboardImportEventJSON> list = this.importEvents;
            DashboardImportEventJSON $receiver = dashboardImportEventJSON;
            $receiver.setPath(path);
            $receiver.setMessage(message);
            $receiver.setSeverity(this.severityError);
            DashboardImportEventJSON dashboardImportEventJSON2 = dashboardImportEventJSON;
            list.add(dashboardImportEventJSON2);
        }

        private final void addWarn(String message, String path) {
            DashboardImportEventJSON dashboardImportEventJSON = new DashboardImportEventJSON();
            List<DashboardImportEventJSON> list = this.importEvents;
            DashboardImportEventJSON $receiver = dashboardImportEventJSON;
            $receiver.setPath(path);
            $receiver.setMessage(message);
            $receiver.setSeverity(this.severityWarn);
            DashboardImportEventJSON dashboardImportEventJSON2 = dashboardImportEventJSON;
            list.add(dashboardImportEventJSON2);
        }

        private final void addNotFoundError(String entityType, String id, String path) {
            this.addError(entityType + " with id [" + id + "] was not found", path);
        }

        private final boolean checkNotEmpty(String value, String path) {
            boolean bl;
            CharSequence charSequence = value;
            if (charSequence == null || charSequence.length() == 0) {
                this.addError("Field value required", path);
                bl = false;
            } else {
                bl = true;
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        private final void createPermissions(XdDashboard dashboard, Iterable<? extends DashboardPermissionImportJSON> permissionsData, String dashboardPath) {
            boolean bl = false;
            for (DashboardPermissionImportJSON dashboardPermissionImportJSON : permissionsData) {
                void idx;
                String permissionPath = dashboardPath + ".permissions[" + (int)idx + ']';
                if (this.checkNotEmpty(dashboardPermissionImportJSON.getPrincipal(), permissionPath + ".principal") && this.checkNotEmpty(dashboardPermissionImportJSON.getType(), permissionPath + ".type") && this.checkNotEmpty(dashboardPermissionImportJSON.getPermission(), permissionPath + ".permission")) {
                    String string2 = dashboardPermissionImportJSON.getPermission();
                    if (string2 == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it.permission!!");
                    if (this.parsePermission(string2, permissionPath + ".permission") == null) {
                    } else {
                        XdUUIDObjectNaturalEntityType xdUUIDObjectNaturalEntityType = (XdUUIDObjectNaturalEntityType)XdAuthorityHolder.Companion;
                        String string3 = dashboardPermissionImportJSON.getPrincipal();
                        if (string3 == null) {
                            Intrinsics.throwNpe();
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it.principal!!");
                        if ((XdAuthorityHolder)this.tryFindByUuid(xdUUIDObjectNaturalEntityType, string3, permissionPath + ".principal") == null) {
                        } else {
                            Permission permission2;
                            XdAuthorityHolder principal;
                            XdDashboardPermission permissionEntity = XdDashboardPermission.Companion.new(dashboard, principal, permission2.toString());
                            if (dashboardPermissionImportJSON.getId() != null) {
                                String string4 = dashboardPermissionImportJSON.getId();
                                if (string4 == null) {
                                    Intrinsics.throwNpe();
                                }
                                permissionEntity.setUuid(string4);
                            }
                        }
                    }
                }
                ++idx;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void createUserDashboards(XdDashboard dashboard, Iterable<? extends UserDashboardImportJSON> userDashboardData, String dashboardPath) {
            boolean bl = false;
            for (UserDashboardImportJSON userDashboardImportJSON : userDashboardData) {
                void idx;
                String userDashboardPath = dashboardPath + ".userDashboards[" + (int)idx + ']';
                if (this.checkNotEmpty(userDashboardImportJSON.getUser(), userDashboardPath + ".user")) {
                    XdUUIDObjectNaturalEntityType xdUUIDObjectNaturalEntityType = (XdUUIDObjectNaturalEntityType)XdBaseUser.Companion;
                    String string2 = userDashboardImportJSON.getUser();
                    if (string2 == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it.user!!");
                    if ((XdBaseUser)this.tryFindByUuid(xdUUIDObjectNaturalEntityType, string2, userDashboardPath + ".user") == null) {
                    } else {
                        XdBaseUser userEntity;
                        Boolean bl2 = userDashboardImportJSON.isFavorite();
                        if (bl2 == null) {
                            bl2 = false;
                        }
                        boolean bl3 = bl2;
                        Integer n = userDashboardImportJSON.getOrdinal();
                        if (n == null) {
                            n = 0;
                        }
                        XdUserDashboard userDashboardEntity = XdUserDashboard.Companion.new(userEntity, dashboard, bl3, n.intValue());
                        if (userDashboardImportJSON.getId() != null) {
                            String string3 = userDashboardImportJSON.getId();
                            if (string3 == null) {
                                Intrinsics.throwNpe();
                            }
                            userDashboardEntity.setUuid(string3);
                        }
                    }
                }
                ++idx;
            }
        }

        private final <T extends XdUUIDObject> T tryFindByUuid(@NotNull XdUUIDObjectNaturalEntityType<T> $receiver, String uuid, String path) {
            Set items = this.notFoundEntities.get($receiver.getEntityType());
            if (items != null && items.contains(uuid)) {
                this.addNotFoundError($receiver.getEntityType(), uuid, path);
                return null;
            }
            T entity = this.findByUuid($receiver, uuid);
            if (entity == null) {
                Set set;
                Map<String, Set<String>> map = this.notFoundEntities;
                String string2 = $receiver.getEntityType();
                Set set2 = items;
                if (set2 == null) {
                    set2 = new LinkedHashSet();
                }
                Set $receiver2 = set = set2;
                $receiver2.add(uuid);
                map.put(string2, set);
                this.addNotFoundError($receiver.getEntityType(), uuid, path);
                return null;
            }
            return entity;
        }

        @Nullable
        public final <T extends XdUUIDObject> T findByUuid(@NotNull XdUUIDObjectNaturalEntityType<T> $receiver, @NotNull String uuid) {
            Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
            Intrinsics.checkParameterIsNotNull((Object)uuid, (String)"uuid");
            String key = uuid + '@' + $receiver.getEntityType();
            XdUUIDObject cached = this.uuidSearchCache.get(key);
            if (cached != null) {
                XdUUIDObject xdUUIDObject = cached;
                if (!(xdUUIDObject instanceof XdUUIDObject)) {
                    xdUUIDObject = null;
                }
                return (T)xdUUIDObject;
            }
            XdUUIDObject found = $receiver.resolve(uuid);
            if (found != null) {
                this.uuidSearchCache.put(key, found);
            }
            return (T)found;
        }

        private final Permission parsePermission(String permission2, String path) {
            try {
                return Permission.valueOf(permission2);
            }
            catch (IllegalArgumentException ex) {
                this.addError("Only " + ArraysKt.joinToString$default((Object[])Permission.values(), null, null, null, (int)0, null, null, (int)63, null) + " are allowed", path);
                return null;
            }
        }

        public BatchHandler(int batchSize) {
            this.batchSize = batchSize;
            this.severityError = "error";
            this.severityWarn = "warn";
            BatchHandler batchHandler = this;
            Object object = new ArrayList();
            batchHandler.importEvents = object;
            batchHandler = this;
            batchHandler.notFoundEntities = object = (Map)new LinkedHashMap();
            batchHandler = this;
            batchHandler.uuidSearchCache = object = (Map)new LinkedHashMap();
        }

        @NotNull
        public static final /* synthetic */ Map access$getUuidSearchCache$p(BatchHandler $this) {
            return $this.uuidSearchCache;
        }

        public static final /* synthetic */ void access$saveDashboard(BatchHandler $this, @NotNull DashboardImportJSON dashboardData, int dashboardIdx) {
            $this.saveDashboard(dashboardData, dashboardIdx);
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/jetpass/dashboard/bulkimport/imports/DashboardImportHandlerImpl$Companion;", "Lmu/KLogging;", "()V", "jetbrains.jetpass.dashboard.bulkimport"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

