/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.common;

import java.util.Arrays;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Priority(value=1000)
@Provider
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00102\u00020\u00012\u00020\u0002:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Ljetbrains/jetpass/rest/common/CorsAllowAllRestResponseFilter;", "Ljavax/ws/rs/container/ContainerRequestFilter;", "Ljavax/ws/rs/container/ContainerResponseFilter;", "()V", "preflightMaxAge", "", "getPreflightMaxAge", "()I", "setPreflightMaxAge", "(I)V", "filter", "", "req", "Ljavax/ws/rs/container/ContainerRequestContext;", "response", "Ljavax/ws/rs/container/ContainerResponseContext;", "Companion", "jetbrains.jetpass.rest.common"})
public final class CorsAllowAllRestResponseFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private int preflightMaxAge = ACCESS_CONTROL_DEFAULT_MAX_AGE;
    @NotNull
    private static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    @NotNull
    private static final String ACCESS_CONTROL_REQUEST_ORIGIN = "Origin";
    @NotNull
    private static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    @NotNull
    private static final String ACCESS_CONTROL_REQUEST_HEADERS = "Access-Control-Request-Headers";
    @NotNull
    private static final String ACCESS_CONTROL_REQUEST_METHOD = "Access-Control-Request-Method";
    @NotNull
    private static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    @NotNull
    private static final String ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
    private static final String ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
    private static final int ACCESS_CONTROL_DEFAULT_MAX_AGE = 864000;
    @NotNull
    private static final String OPTIONS_METHOD = "OPTIONS";
    public static final Companion Companion = new Companion(null);

    public final int getPreflightMaxAge() {
        return this.preflightMaxAge;
    }

    public final void setPreflightMaxAge(int n) {
        this.preflightMaxAge = n;
    }

    public void filter(@NotNull ContainerRequestContext req) {
        Intrinsics.checkParameterIsNotNull((Object)req, (String)"req");
        if (req.getHeaderString(ACCESS_CONTROL_REQUEST_ORIGIN) == null) {
            return;
        }
        if (StringsKt.equals((String)OPTIONS_METHOD, (String)req.getMethod(), (boolean)true)) {
            Response.ResponseBuilder ok = Response.ok();
            ok.header(ACCESS_CONTROL_ALLOW_ORIGIN, (Object)req.getHeaderString(ACCESS_CONTROL_REQUEST_ORIGIN));
            ok.header(ACCESS_CONTROL_ALLOW_METHODS, (Object)req.getHeaderString(ACCESS_CONTROL_REQUEST_METHOD));
            ok.header(ACCESS_CONTROL_ALLOW_HEADERS, (Object)req.getHeaderString(ACCESS_CONTROL_REQUEST_HEADERS));
            ok.header(ACCESS_CONTROL_ALLOW_CREDENTIALS, (Object)String.valueOf(false));
            ok.header(ACCESS_CONTROL_MAX_AGE, (Object)String.valueOf(this.preflightMaxAge));
            req.abortWith(ok.build());
        }
    }

    public void filter(@NotNull ContainerRequestContext req, @NotNull ContainerResponseContext response) {
        Intrinsics.checkParameterIsNotNull((Object)req, (String)"req");
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        String string = req.getHeaderString(ACCESS_CONTROL_REQUEST_ORIGIN);
        if (string == null) {
            return;
        }
        String origin = string;
        MultivaluedMap headers = response.getHeaders();
        if (!headers.containsKey((Object)ACCESS_CONTROL_ALLOW_ORIGIN)) {
            headers.put((Object)ACCESS_CONTROL_ALLOW_ORIGIN, Arrays.asList(origin));
            headers.put((Object)ACCESS_CONTROL_ALLOW_CREDENTIALS, Arrays.asList(String.valueOf(false)));
        }
    }

    static {
        ACCESS_CONTROL_ALLOW_ORIGIN = ACCESS_CONTROL_ALLOW_ORIGIN;
        ACCESS_CONTROL_REQUEST_ORIGIN = ACCESS_CONTROL_REQUEST_ORIGIN;
        ACCESS_CONTROL_ALLOW_HEADERS = ACCESS_CONTROL_ALLOW_HEADERS;
        ACCESS_CONTROL_REQUEST_HEADERS = ACCESS_CONTROL_REQUEST_HEADERS;
        ACCESS_CONTROL_REQUEST_METHOD = ACCESS_CONTROL_REQUEST_METHOD;
        ACCESS_CONTROL_ALLOW_METHODS = ACCESS_CONTROL_ALLOW_METHODS;
        ACCESS_CONTROL_ALLOW_CREDENTIALS = ACCESS_CONTROL_ALLOW_CREDENTIALS;
        ACCESS_CONTROL_MAX_AGE = ACCESS_CONTROL_MAX_AGE;
        ACCESS_CONTROL_DEFAULT_MAX_AGE = 864000;
        OPTIONS_METHOD = OPTIONS_METHOD;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u000eX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0006R\u0014\u0010\u0014\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0006R\u0014\u0010\u0016\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0006R\u0014\u0010\u0018\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0006\u00a8\u0006\u001a"}, d2={"Ljetbrains/jetpass/rest/common/CorsAllowAllRestResponseFilter$Companion;", "", "()V", "ACCESS_CONTROL_ALLOW_CREDENTIALS", "", "getACCESS_CONTROL_ALLOW_CREDENTIALS", "()Ljava/lang/String;", "ACCESS_CONTROL_ALLOW_HEADERS", "getACCESS_CONTROL_ALLOW_HEADERS", "ACCESS_CONTROL_ALLOW_METHODS", "getACCESS_CONTROL_ALLOW_METHODS", "ACCESS_CONTROL_ALLOW_ORIGIN", "getACCESS_CONTROL_ALLOW_ORIGIN", "ACCESS_CONTROL_DEFAULT_MAX_AGE", "", "getACCESS_CONTROL_DEFAULT_MAX_AGE", "()I", "ACCESS_CONTROL_MAX_AGE", "ACCESS_CONTROL_REQUEST_HEADERS", "getACCESS_CONTROL_REQUEST_HEADERS", "ACCESS_CONTROL_REQUEST_METHOD", "getACCESS_CONTROL_REQUEST_METHOD", "ACCESS_CONTROL_REQUEST_ORIGIN", "getACCESS_CONTROL_REQUEST_ORIGIN", "OPTIONS_METHOD", "getOPTIONS_METHOD", "jetbrains.jetpass.rest.common"})
    public static final class Companion {
        @NotNull
        public final String getACCESS_CONTROL_ALLOW_ORIGIN() {
            return ACCESS_CONTROL_ALLOW_ORIGIN;
        }

        @NotNull
        public final String getACCESS_CONTROL_REQUEST_ORIGIN() {
            return ACCESS_CONTROL_REQUEST_ORIGIN;
        }

        @NotNull
        public final String getACCESS_CONTROL_ALLOW_HEADERS() {
            return ACCESS_CONTROL_ALLOW_HEADERS;
        }

        @NotNull
        public final String getACCESS_CONTROL_REQUEST_HEADERS() {
            return ACCESS_CONTROL_REQUEST_HEADERS;
        }

        @NotNull
        public final String getACCESS_CONTROL_REQUEST_METHOD() {
            return ACCESS_CONTROL_REQUEST_METHOD;
        }

        @NotNull
        public final String getACCESS_CONTROL_ALLOW_METHODS() {
            return ACCESS_CONTROL_ALLOW_METHODS;
        }

        @NotNull
        public final String getACCESS_CONTROL_ALLOW_CREDENTIALS() {
            return ACCESS_CONTROL_ALLOW_CREDENTIALS;
        }

        public final int getACCESS_CONTROL_DEFAULT_MAX_AGE() {
            return ACCESS_CONTROL_DEFAULT_MAX_AGE;
        }

        @NotNull
        public final String getOPTIONS_METHOD() {
            return OPTIONS_METHOD;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

