/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.common;

import com.intellij.hub.core.Error;
import com.intellij.hub.core.URIHelper;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import jetbrains.jetpass.auth.module.dnq.authentication.login.ErrorMessage;
import jetbrains.jetpass.auth.module.dnq.authentication.login.OneTimeMessage;
import jetbrains.jetpass.auth.module.dnq.authentication.login.SimpleCodeMessage;
import jetbrains.jetpass.auth.module.dnq.rest.OperationNotFoundPluginException;
import jetbrains.jetpass.dao.api.DataAccessException;
import jetbrains.jetpass.dao.api.FieldException;
import jetbrains.jetpass.dao.api.ItemNotFoundException;
import jetbrains.jetpass.dao.api.LicenseViolationException;
import jetbrains.jetpass.dao.api.NotUniqueFieldException;
import jetbrains.jetpass.dao.api.SecurityViolationException;
import jetbrains.jetpass.dao.api.ServiceIsReadonlyException;
import jetbrains.jetpass.rest.dto.ErrorJSON;
import jetbrains.jetpass.rest.dto.NameValueJSON;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0017\u0010\u0002\u001a\u0002H\u0003\"\u0004\b\u0000\u0010\u0003*\u0004\u0018\u0001H\u0003\u00a2\u0006\u0002\u0010\u0004\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0007\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\b\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\t\u001a\u0016\u0010\u0005\u001a\u00020\u0006*\u00060\nj\u0002`\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u000e\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010*\u00020\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"logger", "Lmu/KLogger;", "checkExists", "T", "(Ljava/lang/Object;)Ljava/lang/Object;", "toJSON", "Ljetbrains/jetpass/rest/dto/ErrorJSON;", "Lcom/intellij/hub/core/Error;", "Ljetbrains/jetpass/auth/module/dnq/authentication/login/OneTimeMessage;", "Ljetbrains/jetpass/dao/api/DataAccessException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "status", "Ljavax/ws/rs/core/Response$StatusType;", "wrapWithRestException", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "jetbrains.jetpass.rest.common"})
public final class ExceptionExtKt {
    private static final KLogger logger = KotlinLogging.INSTANCE.logger("jetbrains.jetpass.rest.common");

    @NotNull
    public static final RuntimeException wrapWithRestException(@NotNull DataAccessException $receiver) {
        Response.Status status;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ErrorJSON error = ExceptionExtKt.toJSON($receiver);
        Integer n = error.getError_code();
        if (n == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"error.error_code!!");
        Response.Status status2 = status = Response.Status.fromStatusCode((int)n);
        Intrinsics.checkExpressionValueIsNotNull((Object)status2, (String)"status");
        if (status2.getStatusCode() < Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()) {
            logger.debug((Throwable)$receiver, (Function0)new Function0<String>($receiver){
                final /* synthetic */ DataAccessException receiver$0;

                @Nullable
                public final String invoke() {
                    return this.receiver$0.getMessage();
                }
                {
                    this.receiver$0 = dataAccessException;
                    super(0);
                }
            });
        } else {
            logger.error((Throwable)$receiver, (Function0)new Function0<String>($receiver){
                final /* synthetic */ DataAccessException receiver$0;

                @Nullable
                public final String invoke() {
                    return this.receiver$0.getMessage();
                }
                {
                    this.receiver$0 = dataAccessException;
                    super(0);
                }
            });
        }
        return (RuntimeException)new WebApplicationException(Response.status((Response.Status)status).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)error).build());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ErrorJSON toJSON(@NotNull DataAccessException $receiver) {
        List list;
        void status;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DataAccessException dataAccessException = $receiver;
        Pair pair = dataAccessException instanceof ItemNotFoundException ? new Pair((Object)Response.Status.NOT_FOUND, null) : (dataAccessException instanceof SecurityViolationException ? new Pair((Object)Response.Status.FORBIDDEN, null) : (dataAccessException instanceof LicenseViolationException ? new Pair((Object)Response.Status.FORBIDDEN, (Object)((LicenseViolationException)$receiver).getField()) : (dataAccessException instanceof NotUniqueFieldException ? new Pair((Object)Response.Status.CONFLICT, (Object)((NotUniqueFieldException)$receiver).getField()) : (dataAccessException instanceof FieldException ? new Pair((Object)Response.Status.BAD_REQUEST, (Object)((FieldException)$receiver).getField()) : (dataAccessException instanceof ServiceIsReadonlyException ? new Pair((Object)Response.Status.SERVICE_UNAVAILABLE, null) : (dataAccessException instanceof OperationNotFoundPluginException ? new Pair((Object)Response.Status.NOT_FOUND, null) : new Pair((Object)Response.Status.BAD_REQUEST, null)))))));
        Response.Status status2 = (Response.Status)pair.component1();
        String field = (String)pair.component2();
        Pair it = pair = new ErrorJSON();
        String string = $receiver.getCode();
        if (string == null) {
            string = status.getReasonPhrase();
        }
        it.setError(string);
        it.setError_code(Integer.valueOf(status.getStatusCode()));
        it.setError_description($receiver.getMessage());
        it.setError_developer_message($receiver.getMessage());
        it.setError_field(field);
        it.setError_uri(URIHelper.INSTANCE.getHubDocsRestURI());
        Pair pair2 = it;
        Map map = $receiver.getParameters();
        if (map != null) {
            Collection<NameValueJSON> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            Map map2 = map;
            Pair pair3 = pair2;
            void var7_7 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList($receiver$iv.size());
            void var9_9 = $receiver$iv$iv;
            Iterator iterator = var9_9.entrySet().iterator();
            while (iterator.hasNext()) {
                void it2;
                NameValueJSON nameValueJSON;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                collection = destination$iv$iv;
                NameValueJSON $receiver2 = nameValueJSON = new NameValueJSON();
                $receiver2.setName((String)it2.getKey());
                $receiver2.setValue((String)it2.getValue());
                NameValueJSON nameValueJSON2 = nameValueJSON;
                collection.add(nameValueJSON2);
            }
            collection = (List)destination$iv$iv;
            pair2 = pair3;
            list = collection;
        } else {
            list = null;
        }
        pair2.setError_params((Iterable)list);
        return pair;
    }

    public static final <T> T checkExists(@Nullable T $receiver) {
        T t = $receiver;
        if (t == null) {
            throw (Throwable)new NotFoundException("Doesn't exist or is not accessible");
        }
        return t;
    }

    @NotNull
    public static final ErrorJSON toJSON(@NotNull Exception $receiver, @NotNull Response.StatusType status) {
        ErrorJSON errorJSON;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
        ErrorJSON $receiver2 = errorJSON = new ErrorJSON();
        $receiver2.setError(status.getReasonPhrase());
        $receiver2.setError_code(Integer.valueOf(status.getStatusCode()));
        $receiver2.setError_description($receiver.getMessage());
        $receiver2.setError_developer_message($receiver.getMessage());
        $receiver2.setError_uri(URIHelper.INSTANCE.getHubDocsRestURI());
        return errorJSON;
    }

    @NotNull
    public static final ErrorJSON toJSON(@NotNull Error $receiver) {
        ErrorJSON errorJSON;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ErrorJSON $receiver2 = errorJSON = new ErrorJSON();
        $receiver2.setError($receiver.getError());
        $receiver2.setError_code(Integer.valueOf($receiver.getStatusCode()));
        $receiver2.setError_description($receiver.getDescription());
        $receiver2.setError_developer_message($receiver.getDeveloperMessage());
        $receiver2.setError_field($receiver.getField());
        URI uRI = $receiver.getUri();
        $receiver2.setError_uri(uRI != null ? uRI.toASCIIString() : null);
        return errorJSON;
    }

    @NotNull
    public static final ErrorJSON toJSON(@NotNull OneTimeMessage $receiver) {
        ErrorJSON errorJSON;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        OneTimeMessage oneTimeMessage = $receiver;
        if (oneTimeMessage instanceof ErrorMessage) {
            errorJSON = ExceptionExtKt.toJSON(((ErrorMessage)$receiver).getError());
        } else if (oneTimeMessage instanceof SimpleCodeMessage) {
            ErrorJSON errorJSON2;
            ErrorJSON $receiver2 = errorJSON2 = new ErrorJSON();
            $receiver2.setError(((SimpleCodeMessage)$receiver).getCode());
            errorJSON = errorJSON2;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return errorJSON;
    }
}

