/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.common.certificates;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.jetpass.api.authority.details.UserDetails;
import jetbrains.jetpass.api.authority.module.Credentials;
import jetbrains.jetpass.api.authority.module.LoginContext;
import jetbrains.jetpass.auth.module.dnq.authentication.ServletRequestCredentials;
import jetbrains.jetpass.auth.module.dnq.authentication.certificate.X509CertificateCredentials;
import jetbrains.jetpass.auth.module.dnq.authentication.certificate.X509ClientCertificate;
import jetbrains.jetpass.dao.dnq.api.JetPassDAOContainer;
import jetbrains.jetpass.rest.common.certificates.CertificateUtilsKt;
import jetbrains.jetpass.rest.common.certificates.ClientCertificateInvalidRequestException;
import jetbrains.jetpass.rest.common.certificates.ClientCertificateUnsuitableRequestException;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u00020\u00072\u0006\u0010\f\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n*\u00020\u0007H\u0002\u001a\u0010\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u00020\u0007\u001a\u0012\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007\u001a\u0012\u0010\u0013\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u001a\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0007H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\b\u00a8\u0006\u0016"}, d2={"CERT_HEADER_NAME", "", "CERT_REQUEST_ATTRIBUTE_NAME", "logger", "Lmu/KLogger;", "isForwardedAsHttps", "", "Ljavax/servlet/http/HttpServletRequest;", "(Ljavax/servlet/http/HttpServletRequest;)Z", "deserializeCertificateHeader", "", "Ljava/security/cert/X509Certificate;", "certHeaderName", "extractCertificateFromAttributes", "extractClientCertificates", "loginWithCertificate", "Ljetbrains/jetpass/api/authority/details/UserDetails;", "Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "request", "printChain", "toLoginContext", "Ljetbrains/jetpass/api/authority/module/LoginContext;", "jetbrains.jetpass.rest.common"})
public final class CertificateUtilsKt {
    @NotNull
    public static final String CERT_REQUEST_ATTRIBUTE_NAME = "javax.servlet.request.X509Certificate";
    @NotNull
    public static final String CERT_HEADER_NAME = "SSL_CLIENT_CERT";
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final UserDetails loginWithCertificate(@NotNull JetPassDAOContainer $receiver, @NotNull HttpServletRequest request) {
        X509CertificateCredentials credentials;
        block2: {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            if (!$receiver.getJetPassFeatureDAO().isEnabledSafe("jetbrains.hub.auth.client.certificate.feature")) {
                throw (Throwable)((Object)ClientCertificateInvalidRequestException.Companion.authDisabled());
            }
            Iterable iterable = $receiver$iv = (Iterable)CertificateUtilsKt.extractClientCertificates(request);
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                X509Certificate x509Certificate = (X509Certificate)item$iv$iv;
                Collection collection = destination$iv$iv;
                X509ClientCertificate x509ClientCertificate = new X509ClientCertificate((X509Certificate)it);
                collection.add(x509ClientCertificate);
            }
            List certificates = (List)destination$iv$iv;
            credentials = new X509CertificateCredentials(certificates, CertificateUtilsKt.toLoginContext(request));
            TransientStoreSession transientStoreSession = DnqUtils.getCurrentTransientSession();
            if (transientStoreSession == null) break block2;
            transientStoreSession.flush();
        }
        return $receiver.getAuthModuleDAO().login((Credentials)credentials, false);
    }

    @NotNull
    public static final List<X509Certificate> extractClientCertificates(@NotNull HttpServletRequest $receiver) {
        Collection collection;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (!$receiver.isSecure() && !CertificateUtilsKt.isForwardedAsHttps($receiver)) {
            throw (Throwable)((Object)ClientCertificateUnsuitableRequestException.Companion.notHttps());
        }
        List<X509Certificate> certificatesFromAttribute = CertificateUtilsKt.extractCertificateFromAttributes($receiver);
        if (certificatesFromAttribute != null && !(collection = (Collection)certificatesFromAttribute).isEmpty()) {
            logger.trace((Function0)new Function0<String>(certificatesFromAttribute){
                final /* synthetic */ List $certificatesFromAttribute;

                @NotNull
                public final String invoke() {
                    return "Found [" + CertificateUtilsKt.access$printChain(this.$certificatesFromAttribute) + "] chain in the javax.servlet.request.X509Certificate attribute of the request";
                }
                {
                    this.$certificatesFromAttribute = list;
                    super(0);
                }
            });
            return certificatesFromAttribute;
        }
        return CertificateUtilsKt.deserializeCertificateHeader($receiver, CERT_HEADER_NAME);
    }

    private static final boolean isForwardedAsHttps(@NotNull HttpServletRequest $receiver) {
        String string = $receiver.getHeader("X-Forwarded-Proto");
        return string != null && StringsKt.equals((String)string, (String)"https", (boolean)true);
    }

    private static final List<X509Certificate> extractCertificateFromAttributes(@NotNull HttpServletRequest $receiver) {
        Object[] chain;
        Object object = $receiver.getAttribute(CERT_REQUEST_ATTRIBUTE_NAME);
        if (!(object instanceof X509Certificate[])) {
            object = null;
        }
        return (chain = (X509Certificate[])object) != null ? ArraysKt.filterNotNull((Object[])chain) : null;
    }

    private static final List<X509Certificate> deserializeCertificateHeader(@NotNull HttpServletRequest $receiver, String certHeaderName) {
        String it;
        String $receiver$iv$iv;
        Enumeration enumeration = $receiver.getHeaders(certHeaderName);
        Intrinsics.checkExpressionValueIsNotNull((Object)enumeration, (String)"getHeaders(certHeaderName)");
        Enumeration enumeration2 = enumeration;
        ArrayList arrayList = Collections.list(enumeration2);
        Intrinsics.checkExpressionValueIsNotNull(arrayList, (String)"java.util.Collections.list(this)");
        Iterable $receiver$iv = arrayList;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it2;
            Object element$iv$iv = iterator.next();
            String string = it2 = (String)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
            CharSequence charSequence = string;
            if (!(charSequence.length() > 0 && Intrinsics.areEqual((Object)it2, (Object)"(null)") ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List headers = (List)destination$iv$iv;
        if (!CollectionsKt.any((Iterable)headers)) {
            throw (Throwable)((Object)ClientCertificateUnsuitableRequestException.Companion.emptyHeader(certHeaderName));
        }
        String string = (String)CollectionsKt.singleOrNull((List)headers);
        if (string == null || (string = !StringsKt.contains$default((CharSequence)(it = ($receiver$iv$iv = string)), (CharSequence)",", (boolean)false, (int)2, null) ? $receiver$iv$iv : null) == null) {
            throw (Throwable)((Object)ClientCertificateInvalidRequestException.Companion.ambiguousHeader(certHeaderName, CollectionsKt.joinToString$default((Iterable)headers, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)));
        }
        String certHeader = string;
        try {
            logger.trace((Function0)new Function0<String>(certHeader){
                final /* synthetic */ String $certHeader;

                @NotNull
                public final String invoke() {
                    return "Trying to deserialize a X509 certificate from the PEM value: " + this.$certHeader;
                }
                {
                    this.$certHeader = string;
                    super(0);
                }
            });
            X509Certificate certificate = jetbrains.jetpass.core.security.cert.CertificateUtilsKt.deserializePemToX509((String)certHeader);
            logger.trace((Function0)new Function0<String>(certificate, certHeader){
                final /* synthetic */ X509Certificate $certificate;
                final /* synthetic */ String $certHeader;

                @NotNull
                public final String invoke() {
                    return "Found [" + this.$certificate.getSubjectDN() + "] certificate in the " + this.$certHeader + " header of the request";
                }
                {
                    this.$certificate = x509Certificate;
                    this.$certHeader = string;
                    super(0);
                }
            });
            iterable = CollectionsKt.listOf((Object)certificate);
        }
        catch (Exception ex) {
            throw (Throwable)((Object)ClientCertificateInvalidRequestException.Companion.invalidCertificate(certHeaderName, certHeader, ex));
        }
        return iterable;
    }

    private static final LoginContext toLoginContext(@NotNull HttpServletRequest $receiver) {
        return (LoginContext)new LoginContext.Basic($receiver.getRemoteAddr(), $receiver.getHeader(ServletRequestCredentials.Companion.getUSER_AGENT_HEADER()), $receiver.getParameter("client_id"));
    }

    private static final String printChain(@NotNull List<? extends X509Certificate> $receiver) {
        return $receiver.isEmpty() ? "[empty chain]" : CollectionsKt.joinToString$default((Iterable)$receiver, (CharSequence)" -> ", (CharSequence)"[", (CharSequence)"]", (int)0, null, (Function1)printChain.1.INSTANCE, (int)24, null);
    }

    @NotNull
    public static final /* synthetic */ String access$printChain(@NotNull List $receiver) {
        return CertificateUtilsKt.printChain($receiver);
    }
}

