/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.service.api;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ljetbrains/jetpass/service/api/ReleaseDateParser;", "", "()V", "format", "Lorg/joda/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "parseCalendar", "Ljava/util/Calendar;", "releaseDate", "", "parseDate", "Lorg/joda/time/DateTime;", "parseLong", "", "printCalendar", "calendar", "jetbrains.jetpass.service.api"})
public final class ReleaseDateParser {
    private static final DateTimeFormatter format;
    public static final ReleaseDateParser INSTANCE;

    @NotNull
    public final String printCalendar(@NotNull Calendar calendar) {
        Intrinsics.checkParameterIsNotNull((Object)calendar, (String)"calendar");
        String string = format.print(calendar.getTimeInMillis());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"format.print(calendar.timeInMillis)");
        return string;
    }

    @NotNull
    public final Calendar parseCalendar(@NotNull String releaseDate) {
        Calendar calendar;
        Intrinsics.checkParameterIsNotNull((Object)releaseDate, (String)"releaseDate");
        Calendar $receiver = calendar = Calendar.getInstance(DateTimeZone.UTC.toTimeZone());
        $receiver.setTime(new Date(INSTANCE.parseDate(releaseDate).getMillis()));
        Calendar calendar2 = calendar;
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar2, (String)"Calendar.getInstance(Dat\u2026te).millis)\n            }");
        return calendar2;
    }

    public final long parseLong(@NotNull String releaseDate) {
        Intrinsics.checkParameterIsNotNull((Object)releaseDate, (String)"releaseDate");
        return this.parseDate(releaseDate).getMillis();
    }

    private final DateTime parseDate(String releaseDate) {
        DateTime dateTime;
        try {
            DateTime dateTime2 = format.parseDateTime(releaseDate);
            Intrinsics.checkExpressionValueIsNotNull((Object)dateTime2, (String)"format.parseDateTime(releaseDate)");
            dateTime = dateTime2;
        }
        catch (IllegalArgumentException ex) {
            DateTime dateTime3 = DateTime.now();
            Intrinsics.checkExpressionValueIsNotNull((Object)dateTime3, (String)"DateTime.now()");
            dateTime = dateTime3;
        }
        return dateTime;
    }

    private ReleaseDateParser() {
    }

    static {
        ReleaseDateParser releaseDateParser;
        INSTANCE = releaseDateParser = new ReleaseDateParser();
        format = DateTimeFormat.forPattern((String)"dd-MM-yyyy").withLocale(Locale.ENGLISH).withZoneUTC();
    }
}

