/*
 * Decompiled with CFR 0.152.
 */
package com.offbytwo.jenkins.model;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.offbytwo.jenkins.client.util.EncodingUtils;
import com.offbytwo.jenkins.helper.Range;
import com.offbytwo.jenkins.model.AllBuilds;
import com.offbytwo.jenkins.model.Build;
import com.offbytwo.jenkins.model.Job;
import com.offbytwo.jenkins.model.QueueItem;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.http.client.HttpResponseException;

public class JobWithDetails
extends Job {
    private String description;
    private String displayName;
    private boolean buildable;
    private List<Build> builds;
    private Build firstBuild;
    private Build lastBuild;
    private Build lastCompletedBuild;
    private Build lastFailedBuild;
    private Build lastStableBuild;
    private Build lastSuccessfulBuild;
    private Build lastUnstableBuild;
    private Build lastUnsuccessfulBuild;
    private int nextBuildNumber;
    private boolean inQueue;
    private QueueItem queueItem;
    private List<Job> downstreamProjects;
    private List<Job> upstreamProjects;
    public static final String EMPTY_DESCRIPTION = "";

    public String getDescription() {
        return this.description;
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isBuildable() {
        return this.buildable;
    }

    public boolean isInQueue() {
        return this.inQueue;
    }

    public List<Build> getBuilds() {
        if (this.builds == null) {
            return Collections.emptyList();
        }
        return Lists.transform(this.builds, (Function)new Function<Build, Build>(){

            public Build apply(Build from) {
                return JobWithDetails.this.buildWithClient(from);
            }
        });
    }

    public List<Build> getAllBuilds() throws IOException {
        String path = "/";
        try {
            List<Build> builds = this.client.get(path + "job/" + EncodingUtils.encode(this.getName()) + "?tree=allBuilds[number[*],url[*],queueId[*]]", AllBuilds.class).getAllBuilds();
            if (builds == null) {
                return Collections.emptyList();
            }
            return Lists.transform(builds, (Function)new Function<Build, Build>(){

                public Build apply(Build from) {
                    return JobWithDetails.this.buildWithClient(from);
                }
            });
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    public List<Build> getAllBuilds(Range range) throws IOException {
        String path = "/job/" + EncodingUtils.encode(this.getName()) + "?tree=allBuilds[number[*],url[*],queueId[*]]";
        try {
            List<Build> builds = this.client.get(path + range.getRangeString(), AllBuilds.class).getAllBuilds();
            if (builds == null) {
                return Collections.emptyList();
            }
            return Lists.transform(builds, (Function)new Function<Build, Build>(){

                public Build apply(Build from) {
                    return JobWithDetails.this.buildWithClient(from);
                }
            });
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    private Build buildWithClient(Build from) {
        Build ret = from;
        if (from != null) {
            ret = new Build(from);
            ret.setClient(this.client);
        }
        return ret;
    }

    public Build getFirstBuild() {
        if (this.firstBuild == null) {
            return Build.BUILD_HAS_NEVER_RUN;
        }
        return this.buildWithClient(this.firstBuild);
    }

    public boolean hasFirstBuildRun() {
        return this.firstBuild != null;
    }

    public Build getLastBuild() {
        if (this.lastBuild == null) {
            return Build.BUILD_HAS_NEVER_RUN;
        }
        return this.buildWithClient(this.lastBuild);
    }

    public boolean hasLastBuildRun() {
        return this.lastBuild != null;
    }

    public Build getLastCompletedBuild() {
        if (this.lastCompletedBuild == null) {
            return Build.BUILD_HAS_NEVER_RUN;
        }
        return this.buildWithClient(this.lastCompletedBuild);
    }

    public boolean hasLastCompletedBuildRun() {
        return this.lastCompletedBuild != null;
    }

    public Build getLastFailedBuild() {
        if (this.lastFailedBuild == null) {
            return Build.BUILD_HAS_NEVER_RUN;
        }
        return this.buildWithClient(this.lastFailedBuild);
    }

    public boolean hasLastFailedBuildRun() {
        return this.lastFailedBuild != null;
    }

    public Build getLastStableBuild() {
        if (this.lastStableBuild == null) {
            return Build.BUILD_HAS_NEVER_RUN;
        }
        return this.buildWithClient(this.lastStableBuild);
    }

    public boolean hasLastStableBuildRun() {
        return this.lastStableBuild != null;
    }

    public Build getLastSuccessfulBuild() {
        if (this.lastSuccessfulBuild == null) {
            return Build.BUILD_HAS_NEVER_RUN;
        }
        return this.buildWithClient(this.lastSuccessfulBuild);
    }

    public boolean hasLastSuccessfulBuildRun() {
        return this.lastSuccessfulBuild != null;
    }

    public Build getLastUnstableBuild() {
        if (this.lastUnstableBuild == null) {
            return Build.BUILD_HAS_NEVER_RUN;
        }
        return this.buildWithClient(this.lastUnstableBuild);
    }

    public boolean hasLastUnstableBuildRun() {
        return this.lastUnstableBuild != null;
    }

    public Build getLastUnsuccessfulBuild() {
        if (this.lastUnsuccessfulBuild == null) {
            return Build.BUILD_HAS_NEVER_RUN;
        }
        return this.buildWithClient(this.lastUnsuccessfulBuild);
    }

    public boolean hasLastUnsuccessfulBuildRun() {
        return this.lastUnsuccessfulBuild != null;
    }

    public int getNextBuildNumber() {
        return this.nextBuildNumber;
    }

    public List<Job> getDownstreamProjects() {
        if (this.downstreamProjects == null) {
            return Collections.emptyList();
        }
        return Lists.transform(this.downstreamProjects, (Function)new JobWithClient());
    }

    public List<Job> getUpstreamProjects() {
        if (this.upstreamProjects == null) {
            return Collections.emptyList();
        }
        return Lists.transform(this.upstreamProjects, (Function)new JobWithClient());
    }

    public QueueItem getQueueItem() {
        return this.queueItem;
    }

    public Build getBuildByNumber(final int buildNumber) {
        Predicate<Build> isMatchingBuildNumber = new Predicate<Build>(){

            public boolean apply(Build input) {
                return input.getNumber() == buildNumber;
            }
        };
        Optional optionalBuild = Iterables.tryFind(this.builds, (Predicate)isMatchingBuildNumber);
        return optionalBuild.orNull() == null ? null : this.buildWithClient((Build)optionalBuild.orNull());
    }

    public void updateDescription(String description) throws IOException {
        this.updateDescription(description, false);
    }

    public void updateDescription(String description, boolean crumbFlag) throws IOException {
        Objects.requireNonNull(description, "description is not allowed to be null.");
        ImmutableMap params = ImmutableMap.of((Object)"description", (Object)description);
        this.client.post_form(this.getUrl() + "/submitDescription?", (Map<String, String>)params, crumbFlag);
    }

    public void clearDescription() throws IOException {
        this.updateDescription(EMPTY_DESCRIPTION);
    }

    public void clearDescription(boolean crumbFlag) throws IOException {
        this.updateDescription(EMPTY_DESCRIPTION, crumbFlag);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.buildable ? 1231 : 1237);
        result = 31 * result + (this.builds == null ? 0 : this.builds.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = 31 * result + (this.downstreamProjects == null ? 0 : this.downstreamProjects.hashCode());
        result = 31 * result + (this.firstBuild == null ? 0 : this.firstBuild.hashCode());
        result = 31 * result + (this.inQueue ? 1231 : 1237);
        result = 31 * result + (this.lastBuild == null ? 0 : this.lastBuild.hashCode());
        result = 31 * result + (this.lastCompletedBuild == null ? 0 : this.lastCompletedBuild.hashCode());
        result = 31 * result + (this.lastFailedBuild == null ? 0 : this.lastFailedBuild.hashCode());
        result = 31 * result + (this.lastStableBuild == null ? 0 : this.lastStableBuild.hashCode());
        result = 31 * result + (this.lastSuccessfulBuild == null ? 0 : this.lastSuccessfulBuild.hashCode());
        result = 31 * result + (this.lastUnstableBuild == null ? 0 : this.lastUnstableBuild.hashCode());
        result = 31 * result + (this.lastUnsuccessfulBuild == null ? 0 : this.lastUnsuccessfulBuild.hashCode());
        result = 31 * result + this.nextBuildNumber;
        result = 31 * result + (this.queueItem == null ? 0 : this.queueItem.hashCode());
        result = 31 * result + (this.upstreamProjects == null ? 0 : this.upstreamProjects.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JobWithDetails other = (JobWithDetails)obj;
        if (this.buildable != other.buildable) {
            return false;
        }
        if (this.builds == null ? other.builds != null : !this.builds.equals(other.builds)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.displayName == null ? other.displayName != null : !this.displayName.equals(other.displayName)) {
            return false;
        }
        if (this.downstreamProjects == null ? other.downstreamProjects != null : !this.downstreamProjects.equals(other.downstreamProjects)) {
            return false;
        }
        if (this.firstBuild == null ? other.firstBuild != null : !this.firstBuild.equals(other.firstBuild)) {
            return false;
        }
        if (this.inQueue != other.inQueue) {
            return false;
        }
        if (this.lastBuild == null ? other.lastBuild != null : !this.lastBuild.equals(other.lastBuild)) {
            return false;
        }
        if (this.lastCompletedBuild == null ? other.lastCompletedBuild != null : !this.lastCompletedBuild.equals(other.lastCompletedBuild)) {
            return false;
        }
        if (this.lastFailedBuild == null ? other.lastFailedBuild != null : !this.lastFailedBuild.equals(other.lastFailedBuild)) {
            return false;
        }
        if (this.lastStableBuild == null ? other.lastStableBuild != null : !this.lastStableBuild.equals(other.lastStableBuild)) {
            return false;
        }
        if (this.lastSuccessfulBuild == null ? other.lastSuccessfulBuild != null : !this.lastSuccessfulBuild.equals(other.lastSuccessfulBuild)) {
            return false;
        }
        if (this.lastUnstableBuild == null ? other.lastUnstableBuild != null : !this.lastUnstableBuild.equals(other.lastUnstableBuild)) {
            return false;
        }
        if (this.lastUnsuccessfulBuild == null ? other.lastUnsuccessfulBuild != null : !this.lastUnsuccessfulBuild.equals(other.lastUnsuccessfulBuild)) {
            return false;
        }
        if (this.nextBuildNumber != other.nextBuildNumber) {
            return false;
        }
        if (this.queueItem == null ? other.queueItem != null : !this.queueItem.equals(other.queueItem)) {
            return false;
        }
        return !(this.upstreamProjects == null ? other.upstreamProjects != null : !this.upstreamProjects.equals(other.upstreamProjects));
    }

    private class JobWithClient
    implements Function<Job, Job> {
        private JobWithClient() {
        }

        public Job apply(Job job) {
            job.setClient(JobWithDetails.this.client);
            return job;
        }
    }
}

