/*
 Copyright 2017 JetBrains s.r.o.

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/**
 * This module provides support for a specific string utility from the standard Java library.
 * All of the other methods that you can use to work with strings in workflows are taken from the standard JavaScript library
 * and behave as described in the {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String|MDN documentation}.
 *
 * @module @jetbrains/youtrack-scripting-api/strings
 */

var utils = Packages.jetbrains.youtrack.scripts.sandbox.Utils;

/**
 * Returns the Levenshtein distance between two strings.
 * Delegates to {@link https://commons.apache.org/proper/commons-lang/javadocs/api-2.6/org/apache/commons/lang/StringUtils.html#getLevenshteinDistance(java.lang.String,%20java.lang.String)|org.apache.commons.lang.StringUtils.getLevenshteinDistance}.
 * @param {string} str1 The first string.
 * @param {string} str2 The string that is compared to the first string.
 */
exports.getLevenshteinDistance = function(str1, str2) {
  return utils.getLevenshteinDistance(str1, str2);
};