var s = {"id":"TS-1", "field":[
    {"name":"Priority", "value":["Normal"]},
    {"name":"Type", "value":["Feature"]},
    {"name":"State", "value":["Open"]},
    {"name":"Subsystem", "value":["No subsystem"]},
    {"name":"Complexity", "value":["1"]},
    {"name":"links", "value":[
        {"type":"Subtask", "role":"subtask", "$":"TS-2"},
        {"type":"Subtask", "role":"subtask", "$":"TS-4"}
    ]},
    {"name":"projectShortName", "value":"TS"},
    {"name":"numberInProject", "value":"1"},
    {"name":"summary", "value":"Feature1"},
    {"name":"created", "value":"1330591311792"},
    {"name":"updated", "value":"1330942700803"},
    {"name":"updaterName", "value":"root"},
    {"name":"reporterName", "value":"root"},
    {"name":"commentsCount", "value":"0"},
    {"name":"votes", "value":"0"}
]};


var model = JavaImporter(Packages.jetbrains.youtrack.workflow.model);
var templateComponent = JavaImporter(Packages.jetbrains.mps.webr.runtime.templateComponent);

//----------------- State Machine related stuff ----------------------------
function statewrapper(state) {

    res = {

        on: function(e) {
            this.event = e;
            return this;
        },

        onEnter : function(a) {
            if (a) state.enter = new Action({action:a});
            return this;
        },

        onExit : function(a) {
            if (a) state.exit = new Action({action:a});
            return this;
        },

        when : function(c) {
            if (c) this.condition = new Guard({guard:c});
            return this;
        },

        perform : function(a) {
            if (a) this.action = new Action({action:a});
            return this;
        },

        transitTo : function(targetStatePath) {
            this.targetState = rule.getState(true, toStrings(targetStatePath));
            return this.create(this.targetState);
        },

        loop : function() {
            this.create(null);
        },

        create : function(targetState) {
            state.addTransition(rule.getEvent(this.event), this.condition, this.action, targetState);
            this.init();
            return this;
        },

        init : function() {
            this.event = null;
            this.condition = null;
            this.action = null;
        }
    }

    res.init();

    return res;
}

function toStrings() {
    var args = arguments;
    var strings = java.lang.reflect.Array.newInstance(java.lang.String, args.length);
    for (i = 0; i < args.length; i++) {
        strings[i] = args[i];
    }
    return strings;
}

from = {
    state : function (statePath) {
        return statewrapper(rule.getState(true, toStrings(statePath)));
    }
};

function statemachine(name, fieldName) {
    with (model) {
        rule = new StateMachine(name, RequiredField.create(fieldName));
    }
    return rule;
}

//-----------End of State Machine related stuff ----------------------------

//---------------- Stateless Rule related stuff ----------------------------
function statelessrule(name, event, guard, action) {
    with (model) {
        rule = new StatelessRule(name, event, new GuardedAction({
            guard : guard,
            action : action
        }));
    }
    return rule;
}
//----------End of Stateless Rule related stuff ----------------------------
