var entities = require('@jetbrains/youtrack-scripting-api/entities');
var workflow = require('@jetbrains/youtrack-scripting-api/workflow');
var days = require("./date-utils").days;

exports.rule = entities.Issue.onSchedule({
  title: workflow.i18n('Raise priority from "Critical" to "Show-stopper" if not resolved in 12 days'),
  search: '#Unresolved priority:Critical',
  cron: '0 30 8 1/1 * ? *',
  guard: function(ctx) {
    return ctx.issue.created < Date.now() - days(12);
  },
  action: function(ctx) {
    ctx.issue.fields.Priority = ctx.Priority.ShowStopper;
  },
  requirements: {
    Priority: {
      type: entities.EnumField.fieldType,
      Critical: {},
      ShowStopper: {
        name: 'Show-stopper'
      }
    }
  }
});