var entities = require('@jetbrains/youtrack-scripting-api/entities');
var workflow = require('@jetbrains/youtrack-scripting-api/workflow');
var days = require("./date-utils").days;

exports.rule = entities.Issue.onSchedule({
  title: workflow.i18n('Raise priority from "Normal" to "Major" if not resolved in 7 days'),
  search: '#Unresolved priority:Normal',
  cron: '0 0 8 1/1 * ? *',
  guard: function(ctx) {
    return ctx.issue.created < Date.now() - days(7);
  },
  action: function(ctx) {
    ctx.issue.fields.Priority = ctx.Priority.Major;
  },
  requirements: {
    Priority: {
      type: entities.EnumField.fieldType,
      Normal: {},
      Major: {}
    }
  }
});