var entities = require('@jetbrains/youtrack-scripting-api/entities');
var workflow = require('@jetbrains/youtrack-scripting-api/workflow');
var dateTime = require('@jetbrains/youtrack-scripting-api/date-time');

exports.rule = entities.Issue.onSchedule({
  title: workflow.i18n('Notify assignee about overdue issues'),
  search: '#Unresolved has: {Due Date}',
  cron: '0 0 10 ? * MON-FRI',
  guard: function(ctx) {
    return ctx.issue.fields.DueDate < Date.now();
  },
  action: function(ctx) {
    var issue = ctx.issue;
    var userToNotify = issue.fields.Assignee;
    if (!userToNotify) {
      userToNotify = issue.project.leader;
    }
    var formattedDate = dateTime.format(issue.fields.DueDate);
    var notificationText = workflow.i18n('Issue became overdue on <i>{0}</i>:', formattedDate) +
      ' <a href="' + issue.url + '">' + issue.summary + '</a><p style="color: gray;font-size: 12px;margin-top: 1em;border-top: 1px solid #D4D5D6">' +
      workflow.i18n('Sincerely yours, YouTrack') + '</p>';
    userToNotify.notify(workflow.i18n('[YouTrack, Issue is overdue]'), notificationText);
  },
  requirements: {
    DueDate: {
      type: entities.Field.dateType,
      name: "Due Date"
    },
    Assignee: {
      type: entities.User.fieldType
    }
  }
});