var workflow = require('@jetbrains/youtrack-scripting-api/workflow');
var entities = require('@jetbrains/youtrack-scripting-api/entities');

exports.rule = entities.Issue.onChange({
  title: workflow.i18n('Require links to duplicate issue when state becomes "Duplicate"'),
  guard: function(ctx) {
    return ctx.issue.fields.becomes(ctx.State, ctx.State.Duplicate);
  },
  action: function(ctx) {
    ctx.issue.required('duplicates', workflow.i18n('Add link to duplicate issue.'));
  },
  requirements: {
    State: {
      type: entities.State.fieldType,
      Duplicate: {}
    },
    Duplicate: {
      type: entities.IssueLinkPrototype,
      outward: 'is duplicated by',
      inward: 'duplicates'
    }
  }
});