var workflow = require('@jetbrains/youtrack-scripting-api/workflow');

exports.words = workflow.i18n('attachments, attachment, attached, attaches, attach, attaching').split(', ');

exports.showMessage = function(what) {
  workflow.message(workflow.i18n('You have mentioned the "{0}" word, don\'t forget to attach it (them).', what));
};

exports.findAndShowMessage = function(text) {
  var found = '';
  if (exports.words.some(function(word) {
      if (text.indexOf(word) > -1) {
        found = word;
        return true;
      }
      return false;
    })) {
    exports.showMessage(found);
  }
};