var entities = require('@jetbrains/youtrack-scripting-api/entities');
var workflow = require('@jetbrains/youtrack-scripting-api/workflow');

exports.rule = entities.Issue.onChange({
  title: workflow.i18n('Block change in Kanban stage for issues that are not ready to pull'),
  guard: function(ctx) {
    var issue = ctx.issue;
    return issue.isReported && issue.fields.isChanged(ctx.Stage);
  },
  action: function(ctx) {
    var issue = ctx.issue;
    workflow.check(issue.fields.KanbanState && issue.fields.KanbanState.name === ctx.KanbanState.ReadyToPull.name,
      workflow.i18n('The issue is not ready to be pulled'));
    issue.fields.KanbanState = ctx.KanbanState.Blocked;
  },
  requirements: {
    Stage: {
      type: entities.State.fieldType
    },
    KanbanState: {
      name: 'Kanban State',
      type: entities.EnumField.fieldType,
      ReadyToPull: {
        name: 'Ready to pull'
      },
      Blocked: {}
    }
  }
});