var entities = require('@jetbrains/youtrack-scripting-api/entities');
var workflow = require('@jetbrains/youtrack-scripting-api/workflow');

exports.rule = entities.Issue.onSchedule({
  title: workflow.i18n('Enable Pomodoro countdown'),
  search: 'has: {Pomodoro countdown} AND Pomodoro countdown: -0 AND (Pomodoro state: {Timer’s running} OR Pomodoro state: {On a break})',
  cron: '0 * * * * ?',
  action: function(ctx) {
    var issueFields = ctx.issue.fields;
    issueFields['Pomodoro countdown'] -= 1;
  },
  requirements: {
    'PomodoroCountdown': {
      name: 'Pomodoro countdown',
      type: entities.Field.integerType
    },
    'PomodoroState': {
      name: 'Pomodoro state',
      type: entities.EnumField.fieldType
    }
  }
});