var entities = require('@jetbrains/youtrack-scripting-api/entities');
var workflow = require('@jetbrains/youtrack-scripting-api/workflow');

function hasAddedLinks(links) {
  return links && links.added && links.added.isNotEmpty();
}

exports.rule = entities.Issue.onChange({
  title: workflow.i18n('Replace existing link when a link that uses a different link type is added to the same issue'),
  action: function(ctx) {
    var issue = ctx.issue;

    var relatesTo = issue.links['relates to'];

    var duplicates = issue.links.duplicates;
    var isDuplicated = issue.links['is duplicated by'];

    var dependsOn = issue.links['depends on'];
    var isRequiredFor = issue.links['is required for'];

    var subtasks = issue.links['subtask of'];
    var parent = issue.links['parent for'];

    var allLinks = [duplicates, isDuplicated, relatesTo, dependsOn, subtasks, isRequiredFor, parent];

    function cleanup(target) {
      if (hasAddedLinks(target)) {
        target.forEach(function(issue) {
          allLinks.filter(function(link) {
            return link && link !== target;
          }).forEach(function(links) {
            links.delete(issue);
          });
        });
      }
    }

    if (hasAddedLinks(duplicates) || hasAddedLinks(relatesTo) || hasAddedLinks(dependsOn) || hasAddedLinks(subtasks)) {
      cleanup(duplicates);
      cleanup(relatesTo);
      cleanup(subtasks);
      cleanup(dependsOn);
    }
  }
});