var entities = require('@jetbrains/youtrack-scripting-api/entities');
var workflow = require('@jetbrains/youtrack-scripting-api/workflow');

exports.rule = entities.Issue.onChange({
  title: workflow.i18n('Block ideal days for epics'),
  guard: function(ctx) {
    var issueFields = ctx.issue.fields;
    return issueFields.Type && issueFields.Type.name === ctx.Type.Epic.name && issueFields.isChanged(ctx.IdealDays);
  },
  action: function(ctx) {
    workflow.check(!ctx.issue.fields.IdealDays, workflow.i18n('Epics can not have ideal days'));
  },
  requirements: {
    Type: {
      type: entities.EnumField.fieldType,
      Epic: {}
    },
    IdealDays: {
      type: entities.Field.integerType,
      name: 'Ideal days'
    }
  }
});