var entities = require('@jetbrains/youtrack-scripting-api/entities');
var workflow = require('@jetbrains/youtrack-scripting-api/workflow');

exports.rule = entities.Issue.onChange({
  title: workflow.i18n('Block story points for tasks'),
  guard: function(ctx) {
    var issueFields = ctx.issue.fields;
    return issueFields.Type && issueFields.Type.name === ctx.Type.Task.name && issueFields.isChanged(ctx.StoryPoints);
  },
  action: function(ctx) {
    workflow.check(!ctx.issue.fields.StoryPoints, workflow.i18n('Tasks can not have story points'));
  },
  requirements: {
    Type: {
      type: entities.EnumField.fieldType,
      Task: {}
    },
    StoryPoints: {
      name: 'Story points',
      type: entities.Field.integerType
    }
  }
});