var entities = require('@jetbrains/youtrack-scripting-api/entities');
var workflow = require('@jetbrains/youtrack-scripting-api/workflow');

exports.rule = entities.Issue.onChange({
  title: workflow.i18n('Assign on move'),
  guard: function(ctx) {
    var issue = ctx.issue;
    return issue.isReported && !issue.fields.Assignee && issue.fields.isChanged(ctx.State);
  },
  action: function(ctx) {
    var issue = ctx.issue;
    if (issue.project.findFieldByName(ctx.Assignee.name).findValueByLogin(ctx.currentUser.login)) {
      issue.fields.Assignee = ctx.currentUser;
    }
  },
  requirements: {
    Assignee: {
      type: entities.User.fieldType
    },
    State: {
      type: entities.State.fieldType
    }
  }
});