var entities = require('@jetbrains/youtrack-scripting-api/entities');
var workflow = require('@jetbrains/youtrack-scripting-api/workflow');

exports.rule = entities.Issue.onChange({
  title: workflow.i18n('Fix parent when all subtasks are resolved'),
  guard: function(ctx) {
    return ctx.issue.isReported && ctx.issue.becomesResolved;
  },
  action: function(ctx) {
    var processParent = function(issue) {
      if (issue.links['subtask of'].isEmpty()) {
        return;
      }
      var parent = issue.links['subtask of'].first();
      if (parent && parent.project && !parent.project.isArchived &&
        parent.isReported && !parent.isResolved) {
        var unresolvedSubtask = parent.links['parent for'].find(function(subtask) {
          return subtask.isReported && !(subtask.fields.State && subtask.fields.State.isResolved);
        });
        if (!unresolvedSubtask) {
          var field = parent.project.findFieldByName(ctx.State.name);
          if (field) {
            var value = field.findValueByName(ctx.State.Done.name);
            if (value) {
              parent.State = value;
              workflow.message(workflow.i18n('Automatically set {0} as Done', parent.id));
              return parent;
            }
          }
        }
      }
    };

    var issue = ctx.issue;
    while (issue) {
      issue = processParent(issue);
    }
  },
  requirements: {
    State: {
      type: entities.State.fieldType,
      Done: {}
    }
  }
});