var entities = require('@jetbrains/youtrack-scripting-api/entities');
var workflow = require('@jetbrains/youtrack-scripting-api/workflow');

exports.rule = entities.Issue.onChange({
  title: workflow.i18n('Assign subtask to assignee of parent issue'),
  guard: function(ctx) {
    return !ctx.issue.links['parent for'].added.isEmpty();
  },
  action: function(ctx) {
    var issue = ctx.issue;

    var safeSetAssignee = function(subtask) {
      if (subtask.project && !subtask.project.isArchived) {
        if (subtask.project.key === issue.project.key || subtask.project.findFieldByName(ctx.Assignee.name)) {
          if (!subtask.fields.Assignee) {
            if (!issue.fields.Assignee ||
              subtask.project.findFieldByName(ctx.Assignee.name).findValueByLogin(issue.fields.Assignee.login)) {
              subtask.fields.Assignee = issue.fields.Assignee;
            }
          }
        }
      }
    };

    issue.links['parent for'].added.forEach(safeSetAssignee);
  },
  requirements: {
    Assignee: {
      type: entities.User.fieldType
    },
    Subtask: {
      type: entities.IssueLinkPrototype,
      name: 'Subtask',
      outward: 'parent for',
      inward: 'subtask of'
    }
  }
});