var entities = require('@jetbrains/youtrack-scripting-api/entities');
var workflow = require('@jetbrains/youtrack-scripting-api/workflow');

exports.rule = entities.Issue.onChange({
  title: workflow.i18n('Remove tag when issue changes to an unresolved state'),
  guard: function(ctx) {
    var issue = ctx.issue;
    return issue.fields.isChanged(ctx.State) && issue.fields.State && !issue.fields.State.isResolved;
  },
  action: function(ctx) {
    var TARGET_TAG_NAME = 'confirmed';
    var issue = ctx.issue;
    var oldValue = issue.fields.oldValue(ctx.State);
    if (oldValue && oldValue.isResolved) {
      issue.removeTag(TARGET_TAG_NAME);
      var wasSuccessfullyRemoved = !!issue.tags.removed.find(function(tag) {
        return tag.name === TARGET_TAG_NAME;
      });
      if (wasSuccessfullyRemoved) {
        workflow.message(workflow.i18n('Tag "{0}" is removed', TARGET_TAG_NAME));
      }
    }
  },
  requirements: {
    State: {
      type: entities.State.fieldType
    }
  }
});