var entities = require('@jetbrains/youtrack-scripting-api/entities');
var workflow = require('@jetbrains/youtrack-scripting-api/workflow');

exports.rule = entities.Issue.onChange({
  title: workflow.i18n('Stop timer when issue is fixed'),
  guard: function(ctx) {
    var issueFields = ctx.issue.fields;
    return issueFields.isChanged(ctx.State) && issueFields.oldValue(ctx.State) &&
      issueFields.oldValue(ctx.State).name === ctx.State.InProgress.name &&
      issueFields.TimerTime;
  },
  action: function(ctx) {
    var issue = ctx.issue;
    var newWorkItem = {
      description: workflow.i18n('The work item automatically added by the timer.'),
      date: Date.now(),
      author: ctx.currentUser,
      duration: issue.project.intervalToWorkingMinutes(issue.fields.TimerTime, Date.now())
    };
    issue.addWorkItem(newWorkItem);
    workflow.message(workflow.i18n('Work time added'));
  },
  requirements: {
    TimerTime: {
      type: entities.Field.dateTimeType,
      name: 'Timer time'
    },
    State: {
      type: entities.State.fieldType,
      InProgress: {
        name: 'In Progress'
      }
    }
  }
});