(function (global) {

    global.__http = {
        'get': function (url, onSuccess, onFailure) {
            var request = new XMLHttpRequest();
            request.open('GET', url, true);
            request.setRequestHeader('Content-Type', 'application/json; charset=UTF-8');

            request.onload = function () {
                if (request.status >= 200 && request.status < 400) {
                    // Success!
                    onSuccess && onSuccess(JSON.parse(request.responseText), request);
                } else {
                    onFailure(request);
                }
            };

            request.onerror = function (res) {
                onFailure(res);
            };

            request.send();
        }
    }
    
}(window));