/*
 Copyright 2017 JetBrains s.r.o.

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

exports.wait = function (mills) {
  Packages.jetbrains.youtrack.imports.sandbox.Util.sleep(mills);
};

exports.dashify = function (str) {
  return str.toLowerCase().replace(new RegExp(' ', 'g'), '-');
};
exports.uglify = function (str) {
  return str + '_';
};
exports.unforbid = function (str, chars) {
  var forbidden = '[' + (chars || ':</>') + ']';
  return str ? str.trim().replace(new RegExp(forbidden, 'g'), '-') : str;
};

exports.throw = function (t) {
  if (typeof t === 'string') {
    throw {message: t};
  } else {
    if (t.javaException){
      throw t.javaException;
    } else {
      throw t;
    }
  }
};