<#ftl attributes={"description":"Overview of the issue update in jabber notification"}>
<#escape x as x?html>
<p>
    <#assign priority = issue.Priority>
    <#assign isShowStopper = (!priority?is_enumerable && priority == "Show-stopper")>
    <#if change.hasEvent("CREATED")>
        <#if (!priority?is_enumerable && priority == "Show-stopper")>
            <@l10n>${issue.reporter.getVisibleName()} hat einen neuen Showstopper gemeldet:</@l10n>
        <#else>
            <@l10n>${issue.reporter.getVisibleName()} hat ein neues Ticket eröffnet:</@l10n>
        </#if>
    <#elseif last_notification?has_content && last_notification>
        <#assign time = change.getWhen()>
        <#if change.hasEvent("PROJECT")>
            <#if from == to>
                <@l10n>
Am ${time} haben Sie ein Ticket in ein Projekt verschoben, in dem Sie keine Ticket-Leseberechtigung haben.
                </@l10n>
            <#else>
                <@l10n>
Am ${time} hat ${from.getVisibleName()} ein Ticket in ein Projekt verschoben, in dem Sie keine Ticket-Leseberechtigung haben.
                </@l10n>
            </#if>
        <#elseif change.hasEvent("PERMITTED")>
            <#if from == to>
                <@l10n>
Am ${time} beschränkten Sie die Sichtbarkeit eines Tickets auf eine Benutzergruppe, der Sie nicht angehören.
                </@l10n>
            <#else>
                <@l10n>
Am ${time} beschränkte ${from.getVisibleName()} die Sichtbarkeit eines Tickets auf eine Benutzergruppe, der Sie nicht angehören.
                </@l10n>
            </#if>
        <#elseif change.hasEvent("DELETED")>
            <#if from == to>
                <@l10n>
Am ${time} löschten Sie ein Ticket im Projekt ${issue.project.name}.
                </@l10n>
            <#else>
                <@l10n>
Am ${time} löschte ${from.getVisibleName()} ein Ticket im Projekt ${issue.project.name}.
                </@l10n>
            </#if>
        <#else>
            <@l10n>
Am ${time} beschränkte ${from.getVisibleName()} den Zugriff auf ein Ticket.
            </@l10n>
        </#if>
    <#else>
        <#if from == to>
            <#if isShowStopper>
                <@l10n>Sie haben folgenden Showstopper geändert:</@l10n>
            <#else>
                <@l10n>Sie haben folgendes Ticket geändert:</@l10n>
            </#if>
        <#else>
            <#if isShowStopper>
                <@l10n>Benutzer ${from.getVisibleName()} hat folgenden Showstopper geändert:</@l10n>
            <#else>
                <@l10n>Benutzer ${from.getVisibleName()} hat folgendes Ticket geändert:</@l10n>
            </#if>
        </#if>
    </#if>
</p>
</#escape>