<#ftl attributes={"description":"Detailed reason for sending email notification to user (HTML)"}>
<#escape x as x?html>

    <#if reason.message?has_content>
        <@l10n>Sie (<b>${to.login}</b>) haben diese Mitteilung aus folgendem Grund erhalten: ${reason.message}.</@l10n>
    <#else>
        <#assign tagsCount = reason.tagReasons?size>
        <#assign savedSearchesCount = reason.savedSearchReasons?size>
        <#assign mentionsCount = reason.mentionReasons?size>
        <#assign onlyMention = (savedSearchesCount == 0) && (tagsCount == 0)>

        <#if onlyMention>
            <#if only_via_duplicate>
                <@l10n>
                    Sie (<b>${to.login}</b>) haben diese Mitteilung erhalten, da Sie die Option
                    <b>Benachrichtigungen über Änderungen im Duplikatcluster erhalten</b> aktiviert hatten und Sie <b>erwähnt</b> wurden.
                </@l10n>
            <#else>
                <@l10n>
                    Sie (<b>${to.login}</b>) haben diese Mitteilung erhalten, da Sie <b>erwähnt</b> wurden.
                </@l10n>
            </#if>
        <#else>
            <#if only_via_duplicate>
                <@l10n>
                    Sie (<b>${to.login}</b>) haben diese Mitteilung erhalten, da Sie die Option
                    <b>Benachrichtigungen über Änderungen im Duplikatcluster erhalten</b> sowie folgende weitere Benachrichtigungen aktiviert haben:
                </@l10n>
            <#else>
                <@l10n>
                    Sie (<b>${to.login}</b>) haben diese Mitteilung erhalten, da Sie folgende Benachrichtigungen aktiviert haben:
                </@l10n>
            </#if>

            <@l10n>
            <#list reason.savedSearchReasons as subreason>
                <#if subreason_has_next>
                    <b>${subreason.name}<#if only_via_duplicate> (${subreason.issueId})</#if></b>,
                <#else>
                    <b>${subreason.name}<#if only_via_duplicate> (${subreason.issueId})</#if></b>
                    <#if (savedSearchesCount > 1)>
                        <#if (tagsCount > 0 || mentionsCount > 0)>
                            gespeicherte Suchen;
                        <#else>
                            gespeicherte Suchen.
                        </#if>
                    <#else>
                        <#if (tagsCount > 0 || mentionsCount > 0)>
                            gespeicherte Suche;
                        <#else>
                            gespeicherte Suche.
                        </#if>
                    </#if>
                </#if>
            </#list>
            </@l10n>

            <@l10n>
            <#list reason.tagReasons as subreason>
                <#if subreason_has_next>
                    <b>${subreason.name}<#if only_via_duplicate> (${subreason.issueId})</#if></b>,
                <#else>
                    <b>${subreason.name}<#if only_via_duplicate> (${subreason.issueId})</#if></b>
                    <#if (tagsCount > 1)>
                        <#if (mentionsCount > 0)>
                            Tags;
                        <#else>
                            Tags.
                        </#if>
                    <#else>
                        <#if (mentionsCount > 0)>
                            Tag;
                        <#else>
                            Tag.
                        </#if>
                    </#if>
                </#if>
            </#list>
            </@l10n>

            <#if (mentionsCount > 0) >
                <@l10n><b>@Erwähnung</b> in einem Kommentar oder einer Ticketbeschreibung.</@l10n>
            </#if>
        </#if>
    </#if>
    <#if last_notification?has_content && last_notification>
        <@l10n>
Wenn Sie weniger Nachrichten dieser Art erhalten möchten, <a href="${Utils.getSettingUrl(to)}">bearbeiten Sie Ihre Benachrichtigungseinstellungen.</a>
        </@l10n>
    <#else>
        <@l10n>
Um das Abonnement zu beenden, können Sie <a href="${Utils.getSettingUrlWithMute(to,issue)}">Benachrichtigungen für dieses Ticket stummschalten</a> oder <a href="${Utils.getSettingUrl(to)}">Ihre Benachrichtigungseinstellungen bearbeiten.</a>
        </@l10n>
    </#if>
</#escape>