<#ftl attributes={"description":"Brief reason for sending jabber notification to user (plain text)"}>
<#escape x as x?html>
    <p>
        <#if reason.message?has_content>
            <@l10n>You received this message because ${reason.message}.</@l10n>
        <#else>
            <#if only_via_duplicate>
                <#assign subreasons  = reason.subreasons>
                <#assign subreason  = subreasons?first>
                <#if (subreasons?size > 1)>
                    <@l10n>You received this message because you had enabled notifications for "${subreason.name}" (${subreason.issueId}) and etc.</@l10n>
                <#else>
                    <@l10n>You received this message because you had enabled notifications for "${subreason.name}" (${subreason.issueId}).</@l10n>
                </#if>
            <#else>
                <#assign mentionsCount = reason.mentionReasons?size>
                <#assign savedSearchesCount = reason.savedSearchReasons?size>
                <#assign subreasonsCount = mentionsCount + savedSearchesCount + reason.tagReasons?size>

                <#if (mentionsCount > 0)>
                    <#if (subreasonsCount > 1)>
                        <@l10n>You received this message because you had enabled notifications for @Mention and etc.</@l10n>
                    <#else>
                        <@l10n>You received this message because you had enabled notifications for @Mention.</@l10n>
                    </#if>
                <#elseif (savedSearchesCount > 0)>
                    <#assign subreason = reason.savedSearchReasons?first>
                    <#if (subreasonsCount > 1)>
                        <@l10n>You received this message because you had enabled notifications for "${subreason.name}" saved search and etc.</@l10n>
                    <#else>
                        <@l10n>You received this message because you had enabled notifications for "${subreason.name}" saved search.</@l10n>
                    </#if>
                <#else>
                    <#assign subreason = reason.tagReasons?first>
                    <#if (subreasonsCount > 1)>
                        <@l10n>You received this message because you had enabled notifications for "${subreason.name}" tag and etc.</@l10n>
                    <#else>
                        <@l10n>You received this message because you had enabled notifications for "${subreason.name}" tag.</@l10n>
                    </#if>
                </#if>
            </#if>
        </#if>
    </p>
</#escape>