<#ftl attributes={"description":"Detailed reason for sending email notification to user (HTML)"}>
<#escape x as x?html>

    <#if reason.message?has_content>
        <@l10n>Usted (<b>${to.login}</b>) ha recibido este mensaje porque ${reason.message}.</@l10n>
    <#else>
        <#assign tagsCount = reason.tagReasons?size>
        <#assign savedSearchesCount = reason.savedSearchReasons?size>
        <#assign mentionsCount = reason.mentionReasons?size>
        <#assign onlyMention = (savedSearchesCount == 0) && (tagsCount == 0)>

        <#if onlyMention>
            <#if only_via_duplicate>
                <@l10n>
                    Usted (<b>${to.login}</b>) ha recibido este mensaje porque había habilitado la opción
                    <b>Recibir notificaciones sobre cambios de un clúster duplicado</b> y se le ha <b>mencionado</b>.
                </@l10n>
            <#else>
                <@l10n>
                    Usted (<b>${to.login}</b>) ha recibido este mensaje porque se le ha <b>mencionado</b>.
                </@l10n>
            </#if>
        <#else>
            <#if only_via_duplicate>
                <@l10n>
                    Usted (<b>${to.login}</b>) ha recibido este mensaje porque había habilitado la opción
                    <b>Recibir notificaciones sobre cambios de un clúster duplicado</b> y las notificaciones de:
                </@l10n>
            <#else>
                <@l10n>
                    Usted (<b>${to.login}</b>) ha recibido este mensaje porque había habilitado las notificaciones de:
                </@l10n>
            </#if>

            <@l10n>
            <#list reason.savedSearchReasons as subreason>
                <#if subreason_has_next>
                    <b>${subreason.name}<#if only_via_duplicate> (${subreason.issueId})</#if></b>,
                <#else>
                    <b>${subreason.name}<#if only_via_duplicate> (${subreason.issueId})</#if></b>
                    <#if (savedSearchesCount > 1)>
                        <#if (tagsCount > 0 || mentionsCount > 0)>
                            búsquedas guardadas;
                        <#else>
                            búsquedas guardadas.
                        </#if>
                    <#else>
                        <#if (tagsCount > 0 || mentionsCount > 0)>
                            búsqueda guardada;
                        <#else>
                            búsqueda guardada.
                        </#if>
                    </#if>
                </#if>
            </#list>
            </@l10n>

            <@l10n>
            <#list reason.tagReasons as subreason>
                <#if subreason_has_next>
                    <b>${subreason.name}<#if only_via_duplicate> (${subreason.issueId})</#if></b>,
                <#else>
                    <b>${subreason.name}<#if only_via_duplicate> (${subreason.issueId})</#if></b>
                    <#if (tagsCount > 1)>
                        <#if (mentionsCount > 0)>
                            etiquetas;
                        <#else>
                            etiquetas.
                        </#if>
                    <#else>
                        <#if (mentionsCount > 0)>
                            etiqueta;
                        <#else>
                            etiqueta.
                        </#if>
                    </#if>
                </#if>
            </#list>
            </@l10n>

            <#if (mentionsCount > 0) >
                <@l10n><b>@Mención</b> en un comentario o una descripción de incidencia.</@l10n>
            </#if>
        </#if>
    </#if>
    <#if last_notification?has_content && last_notification>
        <@l10n>
            Para recibir menos mensajes como este,
            <a href="${Utils.getSettingUrl(to)}">edite sus preferencias de notificaciones.</a>
        </@l10n>
    <#else>
        <@l10n>
            Para cancelar la suscripción puede
            <a href="${Utils.getSettingUrlWithMute(to,issue)}">silenciar las notificaciones de esta incidencia</a> o
            <a href="${Utils.getSettingUrl(to)}">editar sus preferencias de notificaciones.</a>
        </@l10n>
    </#if>
</#escape>