<#ftl attributes={"description":"Overview of the issue update in email notification"}>
<#escape x as x?html>
    <#import "styles.ftl" as styles>
    <div style="${styles.overview_text}
            margin: 14px 0 19px ${styles.icon_width}px;">
        <#assign bold = "font-weight: bold;">
        <#assign priority = issue.Priority>
        <#if (!priority?is_enumerable && (priority == "Critical" || priority == "Show-stopper"))>
            <#assign issueTypeStyle = "color: #cc0000;" + bold>
        <#else>
            <#assign issueTypeStyle = bold>
        </#if>
        <#assign type = issue.Type>
        <#assign time = change.getWhen()>
        <#if type?has_content>
            <#assign issueName = type>
        <#else>
            <#assign issueName = "Issue">
        </#if>
        <#if change.hasEvent("CREATED")>
            <#if type?has_content>
                <@l10n>Création de <span style="${issueTypeStyle}">${type}</span> dans le projet <span style="${bold}">${issue.project.name}</span></@l10n>
            <#else>
                <@l10n>Nouveau <span style="${issueTypeStyle}" >ticket</span> dans le projet <span style="${bold}">${issue.project.name}</span></@l10n>
            </#if>
        <#elseif last_notification?has_content && last_notification>
            <#if change.hasEvent("PROJECT")>
                <#if from==to>
                    <@l10n>
Le ${time}, vous avez déplacé un ticket vers un projet dont vous n'êtes pas autorisé à lire les tickets.
                    </@l10n>
                <#else>
                    <@l10n>
Le ${time}, <span style="${bold}">${from.getVisibleName()}</span> a déplacé un ticket vers un projet dont vous n'êtes pas autorisé à lire les tickets.
                    </@l10n>
                </#if>
            <#elseif change.hasEvent("PERMITTED")>
                <#if from==to>
                    <@l10n>
                        Le ${time}, vous avez limité la visibilité d'un ticket à un groupe d'utilisateurs auquel vous n'appartenez pas.
                    </@l10n>
                <#else>
                    <@l10n>Le ${time}, <span style="${bold}">${from.getVisibleName()}</span> a limité la visibilité d'un ticket à un groupe d'utilisateurs auquel vous n'appartenez pas.</@l10n>
                </#if>
            <#elseif change.hasEvent("DELETED")>
                <#if from==to>
                    <@l10n>
Le ${time}, vous avez supprimé un ticket du projet <span style="${bold}">${issue.project.name}</span>.
                    </@l10n>
                <#else>
                    <@l10n>Le ${time}, <span style="${bold}">${from.getVisibleName()}</span> a supprimé un ticket du projet <span style="${bold}">${issue.project.name}</span>.</@l10n>
                </#if>
            <#else>
                <@l10n>
                    Le ${time}, <span style="${bold}">${from.getVisibleName()}</span> a limité l'accès à un ticket.
                </@l10n>
            </#if>
        <#else>
            <#if from==to>
                <#if type?has_content>
                    <@l10n>
                        <span style="${issueTypeStyle}">${type}</span> a été mis à jour par <span style="${bold}">vous</span>
                        dans le projet ${issue.project.name} à ${time}.
                    </@l10n>
                <#else>
                    <@l10n>
                        <span style="${issueTypeStyle}" >Le ticket</span> a été mis à jour par <span style="${bold}">vous</span>
                        dans le projet ${issue.project.name} à ${time}.
                    </@l10n>
                </#if>
            <#else>
                <#if type?has_content>
                    <@l10n>
                        <span style="${issueTypeStyle}">${type}</span> a été mis à jour par <span style="${bold}">${from.getVisibleName()}</span>
                        dans le projet ${issue.project.name} à ${time}.
                    </@l10n>
                <#else>
                    <@l10n>
                        <span style="${issueTypeStyle}">Le ticket</span> a été mis à jour par <span style="${bold}">${from.getVisibleName()}</span>
                        dans le projet ${issue.project.name} à ${time}.
                    </@l10n>
                </#if>
            </#if>
        </#if>
    </div>
</#escape>