<#ftl attributes={"description":"Overview of the issue update in jabber notification"}>
<#escape x as x?html>
<p>
    <#assign priority = issue.Priority>
    <#assign isShowStopper = (!priority?is_enumerable && priority == "Show-stopper")>
    <#if change.hasEvent("CREATED")>
        <#if (!priority?is_enumerable && priority == "Show-stopper")>
            <@l10n>Un nouveau ticket bloquant a été signalé par ${issue.reporter.getVisibleName()} :</@l10n>
        <#else>
            <@l10n>Un nouvel incident a été signalé par ${issue.reporter.getVisibleName()} :</@l10n>
        </#if>
    <#elseif last_notification?has_content && last_notification>
        <#assign time = change.getWhen()>
        <#if change.hasEvent("PROJECT")>
            <#if from == to>
                <@l10n>
Le ${time}, vous avez déplacé un ticket vers un projet dont vous n'êtes pas autorisé à lire les tickets.                </@l10n>
            <#else>
                <@l10n>
Le ${time}, ${from.getVisibleName()} a déplacé un ticket vers un projet dont vous n'êtes pas autorisé à lire les tickets.
                </@l10n>
            </#if>
        <#elseif change.hasEvent("PERMITTED")>
            <#if from == to>
                <@l10n>
                        Le ${time}, vous avez limité la visibilité d'un ticket à un groupe d'utilisateurs auquel vous n'appartenez pas.
                </@l10n>
            <#else>
                <@l10n>
Le ${time}, ${from.getVisibleName()} a limité la visibilité d'un ticket à un groupe d'utilisateurs auquel vous n'appartenez pas.
                </@l10n>
            </#if>
        <#elseif change.hasEvent("DELETED")>
            <#if from == to>
                <@l10n>
Le ${time}, vous avez supprimé un ticket du projet ${issue.project.name}.
                </@l10n>
            <#else>
                <@l10n>
Le ${time}, ${from.getVisibleName()} a supprimé un ticket du projet ${issue.project.name}.
                </@l10n>
            </#if>
        <#else>
            <@l10n>
Le ${time}, ${from.getVisibleName()} a limité l'accès à un ticket.            </@l10n>
        </#if>
    <#else>
        <#if from == to>
            <#if isShowStopper>
                <@l10n>Vous avez modifié l’incident bloquant :</@l10n>
            <#else>
                <@l10n>Vous avez modifié le ticket :</@l10n>
            </#if>
        <#else>
            <#if isShowStopper>
                <@l10n>L’utilisateur ${from.getVisibleName()} a modifié l’élément bloquant :</@l10n>
            <#else>
                <@l10n>L’utilisateur ${from.getVisibleName()} a modifié le ticket :</@l10n>
            </#if>
        </#if>
    </#if>
</p>
</#escape>